/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.report;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.report.ReportModificationService;
import org.squashtest.tm.web.backend.controller.report.ReportData;
import org.squashtest.tm.web.backend.helper.JsonHelper;
import org.squashtest.tm.web.backend.helper.ReportHelper;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;
import org.squashtest.tm.web.backend.report.criteria.ConciseFormToCriteriaConverter;

@RestController
@RequestMapping(value={"backend/report-definition-view"})
public class ReportDefinitionViewController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportDefinitionViewController.class);
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final ReportModificationService reportModificationService;
    private final ReportsRegistry reportsRegistry;
    private final ReportHelper reportHelper;
    private final ProjectFinder projectFinder;
    private final CurrentUserHelper currentUserHelper;

    public ReportDefinitionViewController(CustomReportLibraryNodeService customReportLibraryNodeService, ReportModificationService reportModificationService, ReportsRegistry reportsRegistry, ReportHelper reportHelper, ProjectFinder projectFinder, CurrentUserHelper currentUserHelper) {
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.reportModificationService = reportModificationService;
        this.reportsRegistry = reportsRegistry;
        this.reportHelper = reportHelper;
        this.projectFinder = projectFinder;
        this.currentUserHelper = currentUserHelper;
    }

    @RequestMapping(value={"/{customReportLibraryNodeId}"}, method={RequestMethod.GET})
    public ReportDefinitionViewModel getReportDefinitionViewModel(@PathVariable Long customReportLibraryNodeId) {
        ReportDefinition reportDefinition = this.customReportLibraryNodeService.findReportDefinitionByNodeId(customReportLibraryNodeId);
        return this.getViewModelFromDefinition(reportDefinition, customReportLibraryNodeId);
    }

    @RequestMapping(value={"/report-definition/{reportDefinitionId}"})
    public ReportDefinitionViewModel getReportDefinitionViewModelByReportId(@PathVariable Long reportDefinitionId) {
        ReportDefinition reportDefinition = this.reportModificationService.findById(reportDefinitionId.longValue());
        return this.getViewModelFromDefinition(reportDefinition, null);
    }

    private ReportDefinitionViewModel getViewModelFromDefinition(ReportDefinition reportDefinition, Long customReportLibraryNodeId) {
        IdentifiedReportDecorator report = this.reportsRegistry.findReport(reportDefinition.getPluginNamespace());
        if (Objects.nonNull(report)) {
            Map<String, Object> form = null;
            try {
                form = JsonHelper.deserialize(reportDefinition.getParameters());
            }
            catch (IOException e) {
                LOGGER.error("the report : " + reportDefinition.getName() + " has corrupted parameters.", (Throwable)e);
            }
            List readableProjectIds = this.currentUserHelper.findReadableProjectIds();
            List projectIds = this.projectFinder.findAllProjectIdsOrderedByName(readableProjectIds);
            Map<String, Criteria> crit = new ConciseFormToCriteriaConverter(report, projectIds).convert(form);
            return new ReportDefinitionViewModel(reportDefinition, customReportLibraryNodeId, this.reportHelper.getAttributesForReport(report, crit, projectIds), report);
        }
        return new ReportDefinitionViewModel(reportDefinition, customReportLibraryNodeId);
    }

    static class ReportDefinitionViewModel {
        private final Long id;
        private final Long customReportLibraryNodeId;
        private final Long projectId;
        private final String name;
        private final String description;
        private final String summary;
        private final String pluginNamespace;
        private final String parameters;
        private Date createdOn;
        private String createdBy;
        private Date lastModifiedOn;
        private String lastModifiedBy;
        private Map<String, List<String>> attributes;
        private String reportLabel;
        private ReportData report;
        private boolean missingPlugin = true;

        public ReportDefinitionViewModel(ReportDefinition reportDefinition, Long customReportLibraryNodeId) {
            this.id = reportDefinition.getId();
            this.customReportLibraryNodeId = customReportLibraryNodeId;
            this.projectId = reportDefinition.getProject().getId();
            this.name = reportDefinition.getName();
            this.description = reportDefinition.getDescription();
            this.summary = reportDefinition.getSummary();
            this.pluginNamespace = reportDefinition.getPluginNamespace();
            this.parameters = reportDefinition.getParameters();
            this.attributes = new HashMap<String, List<String>>();
            this.doAuditableAttributes(reportDefinition);
        }

        public ReportDefinitionViewModel(ReportDefinition reportDefinition, Long customReportLibraryNodeId, Map<String, List<String>> reportAttributes, IdentifiedReportDecorator report) {
            this(reportDefinition, customReportLibraryNodeId);
            this.reportLabel = report.getLabel();
            this.missingPlugin = false;
            this.attributes = reportAttributes;
            this.report = new ReportData(report);
        }

        private void doAuditableAttributes(ReportDefinition def) {
            ReportDefinition audit = def;
            this.createdBy = audit.getCreatedBy();
            this.lastModifiedBy = audit.getLastModifiedBy();
            this.createdOn = audit.getCreatedOn();
            this.lastModifiedOn = audit.getLastModifiedOn();
        }

        public Long getId() {
            return this.id;
        }

        public Long getCustomReportLibraryNodeId() {
            return this.customReportLibraryNodeId;
        }

        public Long getProjectId() {
            return this.projectId;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getPluginNamespace() {
            return this.pluginNamespace;
        }

        public String getParameters() {
            return this.parameters;
        }

        public Date getCreatedOn() {
            return this.createdOn;
        }

        public String getCreatedBy() {
            return this.createdBy;
        }

        public Date getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        public String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public Map<String, List<String>> getAttributes() {
            return this.attributes;
        }

        public String getReportLabel() {
            return this.reportLabel;
        }

        public ReportData getReport() {
            return this.report;
        }

        public boolean isMissingPlugin() {
            return this.missingPlugin;
        }
    }
}

