/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.report;

import org.squashtest.tm.api.report.form.CheckboxInput;
import org.squashtest.tm.api.report.form.InputType;
import org.squashtest.tm.api.report.form.NodeType;
import org.squashtest.tm.api.report.form.OptionInput;
import org.squashtest.tm.api.report.form.composite.TagPickerOption;
import org.squashtest.tm.api.report.form.composite.TreePickerOption;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.web.backend.controller.report.InputJson;

public class OptionInputJson
implements InputJson {
    private String name;
    private String label;
    private String value = "";
    private boolean defaultSelected = false;
    private String givesAccessTo = "none";
    private boolean isComposite = false;
    private InputType contentType;
    private String disabledBy;

    public OptionInputJson(OptionInput optionInput) {
        this.name = optionInput.getName();
        this.value = optionInput.getValue();
        this.defaultSelected = optionInput.isDefaultSelected();
        this.givesAccessTo = optionInput.getGivesAccessTo();
        this.label = optionInput.getLabel();
        this.disabledBy = optionInput.getDisabledBy();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDefaultSelected() {
        return this.defaultSelected;
    }

    public String getGivesAccessTo() {
        return this.givesAccessTo;
    }

    public boolean isComposite() {
        return this.isComposite;
    }

    public void setComposite(boolean composite) {
        this.isComposite = composite;
    }

    public String getLabel() {
        return this.label;
    }

    public InputType getContentType() {
        return this.contentType;
    }

    public void setContentType(InputType contentType) {
        this.contentType = contentType;
    }

    public String getDisabledBy() {
        return this.disabledBy;
    }

    public static class CheckBoxInputJson
    extends OptionInputJson {
        private final InputType type;
        private final String helpMessage;

        public CheckBoxInputJson(CheckboxInput checkboxInput) {
            super((OptionInput)checkboxInput);
            this.type = checkboxInput.getType();
            this.helpMessage = checkboxInput.getHelpMessage();
        }

        public InputType getType() {
            return this.type;
        }

        @Override
        public String getHelpMessage() {
            return this.helpMessage;
        }
    }

    public static class TagPickerOptionJson
    extends OptionInputJson {
        private final BindableEntity bindableEntity;

        public TagPickerOptionJson(TagPickerOption tagPickerOption) {
            super((OptionInput)tagPickerOption);
            this.bindableEntity = BindableEntity.valueOf((String)tagPickerOption.getPickerBoundEntity());
        }

        public BindableEntity getBindableEntity() {
            return this.bindableEntity;
        }
    }

    public static class TreePickerOptionJson
    extends OptionInputJson {
        private final NodeType nodeType;

        public TreePickerOptionJson(TreePickerOption treePickerOption) {
            super((OptionInput)treePickerOption);
            this.nodeType = treePickerOption.getPickedNodeType();
        }

        public NodeType getNodeType() {
            return this.nodeType;
        }
    }
}

