/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.campaign.ExecutionCreationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.campaign.TestPlanItemManagerService;
import org.squashtest.tm.service.display.campaign.TestPlanItemDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.web.backend.controller.campaign.CampaignTestPlanManagerController;
import org.squashtest.tm.web.backend.controller.campaign.IterationTestPlanManagerController;

@RestController
@RequestMapping(value={"backend/test-plan-item"})
public class TestPlanItemController {
    private final IterationTestPlanManagerService iterationTestPlanManagerService;
    private final CampaignTestPlanManagerService campaignTestPlanManagerService;
    private final TestPlanItemManagerService testPlanItemManagerService;
    private final ExecutionCreationService executionCreationService;
    private final TestPlanItemDisplayService testPlanItemDisplayService;

    public TestPlanItemController(IterationTestPlanManagerService iterationTestPlanManagerService, CampaignTestPlanManagerService campaignTestPlanManagerService, TestPlanItemManagerService testPlanItemManagerService, ExecutionCreationService executionCreationService, TestPlanItemDisplayService testPlanItemDisplayService) {
        this.iterationTestPlanManagerService = iterationTestPlanManagerService;
        this.campaignTestPlanManagerService = campaignTestPlanManagerService;
        this.testPlanItemManagerService = testPlanItemManagerService;
        this.executionCreationService = executionCreationService;
        this.testPlanItemDisplayService = testPlanItemDisplayService;
    }

    @PostMapping(value={"iteration/{testPlanItemId}/dataset"})
    public Long setDatasetToIterationTestPlanItem(@PathVariable long testPlanItemId, @RequestBody DatasetIdRecord patch) {
        this.iterationTestPlanManagerService.changeDataset(testPlanItemId, patch.datasetId());
        return patch.datasetId();
    }

    @PostMapping(value={"test-suite/{testPlanItemId}/dataset"})
    public Long setDatasetToTestSuiteTestPlanItem(@PathVariable long testPlanItemId, @RequestBody DatasetIdRecord patch) {
        this.iterationTestPlanManagerService.changeDataset(testPlanItemId, patch.datasetId());
        return patch.datasetId();
    }

    @PostMapping(value={"campaign/{testPlanItemId}/dataset"})
    public Long setDatasetToCampaignTestPlanItem(@PathVariable long testPlanItemId, @RequestBody DatasetIdRecord patch) {
        this.campaignTestPlanManagerService.changeDataset(testPlanItemId, patch.datasetId());
        return patch.datasetId();
    }

    @PostMapping(value={"sprint-req-version/{testPlanItemId}/dataset"})
    public Long setDatasetToSprintRequirementTestPlanItem(@PathVariable long testPlanItemId, @RequestBody DatasetIdRecord patch) {
        this.testPlanItemManagerService.changeDataset(testPlanItemId, patch.datasetId());
        return patch.datasetId();
    }

    @PostMapping(value={"{testPlanItemId}/new-manual-execution"})
    public CreateExecutionResponse createExecution(@PathVariable long testPlanItemId) {
        Execution newExecution = this.executionCreationService.createExecution(testPlanItemId);
        return new CreateExecutionResponse(newExecution.getId());
    }

    @PostMapping(value={"{testPlanItemId}/executions"})
    public GridResponse getExecutions(@PathVariable long testPlanItemId, @RequestBody GridRequest gridRequest) {
        return this.testPlanItemDisplayService.getTestPlanItemExecutions(testPlanItemId, gridRequest);
    }

    @PostMapping(value={"/{testPlanItemsIds}/assign-user"})
    public Long assignUserToIterationTestPlanItem(@PathVariable List<Long> testPlanItemsIds, @RequestBody IterationTestPlanManagerController.IterationTestPlanItemPatch patch) {
        this.iterationTestPlanManagerService.assignUserToTestPlanItems(testPlanItemsIds, patch.getAssignee().longValue());
        return patch.getAssignee();
    }

    @PostMapping(value={"/{testPlanItemsIds}/execution-status"})
    public void updateIterationTestPlanItemsStatus(@PathVariable List<Long> testPlanItemsIds, @RequestBody IterationTestPlanManagerController.IterationTestPlanItemPatch patch) {
        this.iterationTestPlanManagerService.forceExecutionStatus(testPlanItemsIds, patch.getExecutionStatus());
    }

    @PostMapping(value={"/{testPlanItemIds}/status"})
    public void updateTestPlanItemsStatus(@PathVariable List<Long> testPlanItemIds, @RequestBody ExecutionStatusRecord requestBody) {
        this.testPlanItemManagerService.applyFastPass(testPlanItemIds, requestBody.executionStatus());
    }

    @PostMapping(value={"/{testPlanItemsIds}/assign-user-to-ctpi"})
    public Long assignUserToCampaignTestPlanItem(@PathVariable List<Long> testPlanItemsIds, @RequestBody CampaignTestPlanManagerController.CampaignTestPlanItemPatch patch) {
        this.campaignTestPlanManagerService.assignUserToTestPlanItems(testPlanItemsIds, patch.getAssignee());
        return patch.getAssignee();
    }

    @DeleteMapping(value={"/{testPlanItemId}/execution/{executionIds}"})
    public void deleteExecutions(@PathVariable long testPlanItemId, @PathVariable List<Long> executionIds) {
        this.testPlanItemManagerService.deleteExecutionsAndRemoveFromTestPlanItem(executionIds, testPlanItemId);
    }

    public record CreateExecutionResponse(Long executionId) {
    }

    public record DatasetIdRecord(Long datasetId) {
    }

    public record ExecutionStatusRecord(String executionStatus) {
    }
}

