/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.bugtracker;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.csp.core.bugtracker.spi.DefaultOAuth2FormValues;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.bugtracker.BugTrackerModificationService;
import org.squashtest.tm.service.display.bugtracker.BugTrackerDisplayService;
import org.squashtest.tm.service.internal.display.dto.BugTrackerViewDto;
import org.squashtest.tm.service.internal.display.dto.CredentialsDto;
import org.squashtest.tm.service.internal.servers.OAuth2ConsumerService;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@RestController
@RequestMapping(value={"/backend/bugtracker-view"})
public class BugTrackerViewController {
    private final BugTrackerDisplayService bugTrackerDisplayService;
    private final StoredCredentialsManager credentialsManager;
    private final BugTrackerModificationService bugTrackerModificationService;
    private final BugTrackerFinderService bugTrackerFinderService;
    private final OAuth2ConsumerService oAuth2ConsumerService;

    BugTrackerViewController(BugTrackerDisplayService bugTrackerDisplayService, StoredCredentialsManager credentialsManager, BugTrackerModificationService bugTrackerModificationService, BugTrackerFinderService bugTrackerFinderService, OAuth2ConsumerService oAuth2ConsumerService) {
        this.bugTrackerDisplayService = bugTrackerDisplayService;
        this.credentialsManager = credentialsManager;
        this.bugTrackerModificationService = bugTrackerModificationService;
        this.bugTrackerFinderService = bugTrackerFinderService;
        this.oAuth2ConsumerService = oAuth2ConsumerService;
    }

    @GetMapping(value={"/{bugTrackerId}"})
    @ResponseBody
    BugTrackerViewDto getBugTrackerView(@PathVariable Long bugTrackerId) {
        BugTrackerViewDto dto = this.bugTrackerDisplayService.getBugTrackerView(bugTrackerId);
        dto.setBugTrackerKinds(this.findBugTrackerKinds());
        ManageableCredentials credentials = this.credentialsManager.findAppLevelCredentials(bugTrackerId.longValue());
        dto.setCredentials(CredentialsDto.from((ManageableCredentials)credentials));
        ServerAuthConfiguration configuration = this.credentialsManager.findServerAuthConfiguration(bugTrackerId.longValue());
        dto.setAuthConfiguration(configuration);
        BugTracker bugTracker = this.bugTrackerFinderService.findById(bugTrackerId.longValue());
        List<String> supportedProtocols = this.getSupportedAuthenticationProtocols(bugTracker);
        dto.setSupportedAuthenticationProtocols(supportedProtocols);
        return dto;
    }

    @GetMapping(value={"/{bugTrackerId}/oauth2/default-form-values"})
    @ResponseBody
    public DefaultOAuth2FormValues askOauth2Token(@PathVariable(value="bugTrackerId") long bugTrackerId) {
        return this.oAuth2ConsumerService.getDefaultOAuth2FormValue(Long.valueOf(bugTrackerId));
    }

    private List<String> getSupportedAuthenticationProtocols(BugTracker bugTracker) {
        return Arrays.stream(this.bugTrackerModificationService.getSupportedProtocols(bugTracker)).map(Enum::name).collect(Collectors.toList());
    }

    private Set<String> findBugTrackerKinds() {
        return this.bugTrackerFinderService.findBugTrackerKinds().stream().map(HTMLCleanupUtils::cleanHtml).collect(Collectors.toSet());
    }
}

