/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.attachment;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.exception.attachment.AttachmentException;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.display.attachment.FileViewerService;
import org.squashtest.tm.service.internal.display.attachment.FileViewerExtension;
import org.squashtest.tm.service.internal.display.dto.FileViewerDto;
import org.squashtest.tm.service.internal.display.dto.FileViewerRequest;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;

@RestController
@RequestMapping(value={"backend/file-viewer"})
public class FileViewerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileViewerController.class);
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String ERROR_MESSAGE = "An error occurred while viewing the attachment : ";
    private static final String ATTACHMENT_FILENAME = "attachment; filename=";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private FileViewerService fileViewerService;

    @GetMapping(value={"/attachment/{attachmentId}"})
    public void previewAttachment(@PathVariable(value="attachmentId") Long attachmentId, @RequestParam(name="target", required=false) String target, HttpServletResponse response) {
        try {
            Attachment attachment = this.attachmentManagerService.findAttachment(attachmentId);
            FileViewerRequest viewerRequest = FileViewerRequest.fromAttachment((Attachment)attachment, (String)target);
            if (Objects.nonNull(viewerRequest.getFileType())) {
                FileViewerDto fileViewer = this.fileViewerService.preview(viewerRequest);
                this.displayPreview(response, fileViewer, viewerRequest.getFileName());
            } else {
                LOGGER.info("Unable to view the attachment : " + viewerRequest.getFileName() + ". The file extension is not supported." + " The attachment will be automatically downloaded.");
                this.downloadAttachment(attachmentId, response, viewerRequest.getFileName());
            }
        }
        catch (IOException e) {
            LOGGER.warn(ERROR_MESSAGE + e.getMessage(), (Throwable)e);
            response.setStatus(500);
        }
        catch (IllegalArgumentException | AccessDeniedException e) {
            LOGGER.warn(ERROR_MESSAGE + e.getMessage(), e);
            response.setStatus(404);
        }
    }

    @GetMapping(value={"/archive/{attachmentId}"})
    public TreeGridResponse getArchiveTree(@PathVariable(value="attachmentId") Long attachmentId) {
        try {
            Attachment attachment = this.attachmentManagerService.findAttachment(attachmentId);
            FileViewerRequest viewerRequest = FileViewerRequest.fromAttachment((Attachment)attachment, null);
            if (FileViewerExtension.TAR.equals((Object)viewerRequest.getFileType())) {
                return this.fileViewerService.getArchiveFileTree(viewerRequest);
            }
            throw new IllegalArgumentException("File id : " + attachmentId + " is not a valid archive file.");
        }
        catch (IOException e) {
            LOGGER.warn("An error occurred while getting the archive tree : " + e.getMessage(), (Throwable)e);
            throw new AttachmentException((Throwable)e);
        }
    }

    @GetMapping(value={"/archive-source/{attachmentId}/**"})
    public void getArchiveContentTarget(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="attachmentId") Long attachmentId) throws IOException {
        String uri;
        String target;
        Attachment attachment = this.attachmentManagerService.findAttachment(attachmentId);
        FileViewerRequest viewerRequest = FileViewerRequest.fromAttachment((Attachment)attachment, (String)(target = FileViewerController.extractTargetFileFromURI(attachmentId, uri = request.getRequestURI())));
        if (Objects.nonNull(viewerRequest.getFileType())) {
            FileViewerDto fileViewer = this.fileViewerService.preview(viewerRequest);
            this.displayPreview(response, fileViewer, viewerRequest.getFileName());
        } else {
            LOGGER.info("Unable to get the archive content : " + viewerRequest.getFileName() + ". The file extension is not supported.");
            response.setStatus(400);
        }
    }

    private static String extractTargetFileFromURI(Long attachmentId, String uri) {
        String target = uri.substring(uri.indexOf(attachmentId.toString()) + attachmentId.toString().length() + 1);
        if (target.contains("target:")) {
            target = target.substring(target.indexOf("target:") + "target:".length());
        }
        return target;
    }

    @GetMapping(value={"/preview/file"}, params={"source"})
    public void previewFile(@RequestParam(value="source") String source, HttpServletResponse response) {
        File file = new File(source);
        FileViewerRequest viewerRequest = FileViewerRequest.fromFile((File)file);
        try {
            if (Objects.nonNull(viewerRequest.getFileType())) {
                FileViewerDto fileViewer = this.fileViewerService.preview(viewerRequest);
                this.displayPreview(response, fileViewer, viewerRequest.getFileName());
            }
        }
        catch (IOException e) {
            LOGGER.warn(ERROR_MESSAGE + e.getMessage(), (Throwable)e);
            response.setStatus(500);
        }
    }

    @GetMapping(value={"/download/file"}, params={"source"})
    @ResponseBody
    public FileSystemResource downloadFile(@RequestParam(value="source") String filePath, HttpServletResponse response) {
        File logfile = new File(filePath);
        response.setContentType("application/octet-stream");
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + logfile.getName());
        return new FileSystemResource(logfile);
    }

    private void displayPreview(HttpServletResponse response, FileViewerDto fileViewer, String formattedName) throws IOException {
        response.setHeader(CONTENT_DISPOSITION, "inline; filename=" + formattedName);
        response.setContentType(fileViewer.getType().media);
        response.setCharacterEncoding(Charset.defaultCharset().name());
        if (fileViewer.getType().isOutputStream) {
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write((byte[])fileViewer.getContent());
        } else {
            PrintWriter writer = response.getWriter();
            writer.print(fileViewer.getContent());
            writer.flush();
        }
    }

    private void downloadAttachment(long attachmentId, HttpServletResponse response, String formattedName) throws IOException {
        response.setContentType("application/octet-stream");
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + formattedName);
        ServletOutputStream outStream = response.getOutputStream();
        this.attachmentManagerService.writeContent(attachmentId, (OutputStream)outStream);
    }
}

