/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.artificialintelligence.testcasegeneration;

import java.util.Collections;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.artificialintelligence.testcasegeneration.AiTestCaseGenerationService;
import org.squashtest.tm.service.internal.dto.GenerateTestCasesDataDto;
import org.squashtest.tm.service.internal.dto.TestCasesCreationFromAiDto;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;

@RestController
@RequestMapping(value={"backend/ai-test-case-generation"})
public class AiTestCaseGenerationController {
    private final AiTestCaseGenerationService aiTestCaseGenerationService;
    private final EntityPathHeaderService entityPathHeaderService;

    public AiTestCaseGenerationController(AiTestCaseGenerationService aiTestCaseGenerationService, EntityPathHeaderService entityPathHeaderService) {
        this.aiTestCaseGenerationService = aiTestCaseGenerationService;
        this.entityPathHeaderService = entityPathHeaderService;
    }

    @ResponseBody
    @PostMapping(value={"api-call"})
    public String generateTestCaseFromRequirementUsingAi(@RequestBody GenerateTestCasesDataDto generateTestCasesDataDto) {
        return this.aiTestCaseGenerationService.generateTestCaseFromRequirementUsingAiUserSide(generateTestCasesDataDto.getSourceProjectId().longValue(), generateTestCasesDataDto.getRequirementDescription());
    }

    @ResponseBody
    @GetMapping(value={"folder-path/{chosenFolderTclnId}"})
    public Map<String, String> getChosenFolderFullPath(@PathVariable long chosenFolderTclnId) {
        String path = this.entityPathHeaderService.buildTCLNPathHeader(Long.valueOf(chosenFolderTclnId));
        return Collections.singletonMap("folderPath", path);
    }

    @ResponseBody
    @PostMapping(value={"create-test-cases/{requirementVersionId}"})
    public void persistTestCasesGeneratedByAi(@PathVariable Long requirementVersionId, @RequestBody TestCasesCreationFromAiDto testCasesData) {
        Long testCaseLibraryId = this.aiTestCaseGenerationService.findTargetTestCaseLibraryId(testCasesData.getTargetProjectId());
        this.aiTestCaseGenerationService.persistTestCaseFromAi(testCaseLibraryId.longValue(), requirementVersionId, testCasesData);
    }
}

