/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.report.criteria;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.form.InputType;
import org.squashtest.tm.web.backend.report.criteria.CheckboxEntryConverter;
import org.squashtest.tm.web.backend.report.criteria.DateEntryConverter;
import org.squashtest.tm.web.backend.report.criteria.EmptyCriteria;
import org.squashtest.tm.web.backend.report.criteria.FormEntryNotConvertibleException;
import org.squashtest.tm.web.backend.report.criteria.GenericSimpleEntryConverter;
import org.squashtest.tm.web.backend.report.criteria.InconsistentMultiValuedEntryException;
import org.squashtest.tm.web.backend.report.criteria.MultiOptionsCriteria;
import org.squashtest.tm.web.backend.report.criteria.MultiValuesCriteria;
import org.squashtest.tm.web.backend.report.criteria.SimpleCriteria;
import org.squashtest.tm.web.backend.report.criteria.SimpleEntryConverter;

public class FormToCriteriaConverter {
    private static final String INPUT_SELECTED = "selected";
    private static final String INPUT_VALUE = "value";
    private static final String INPUT_TYPE = "type";
    private static final Logger LOGGER = LoggerFactory.getLogger(FormToCriteriaConverter.class);
    private final Map<InputType, SimpleEntryConverter> simpleEntryConverterByType;
    private final SimpleEntryConverter simpleEntryDefaultConverter = new GenericSimpleEntryConverter();
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$api$report$form$InputType;

    public FormToCriteriaConverter() {
        this.simpleEntryConverterByType = new HashMap();
        this.simpleEntryConverterByType.put(InputType.DATE, new DateEntryConverter());
        this.simpleEntryConverterByType.put(InputType.CHECKBOX, new CheckboxEntryConverter());
        this.simpleEntryConverterByType.put(InputType.TEXT, this.simpleEntryDefaultConverter);
        this.simpleEntryConverterByType.put(InputType.PASSWORD, this.simpleEntryDefaultConverter);
        this.simpleEntryConverterByType.put(InputType.TREE_PICKER, this.simpleEntryDefaultConverter);
        this.simpleEntryConverterByType.put(InputType.MILESTONE_PICKER, this.simpleEntryDefaultConverter);
        this.simpleEntryConverterByType.put(InputType.TAG_PICKER, this.simpleEntryDefaultConverter);
    }

    public Map<String, Criteria> convert(Map<String, Object> formValues) {
        HashMap<String, Criteria> res = new HashMap<String, Criteria>();
        for (Map.Entry<String, Object> entry : formValues.entrySet()) {
            Criteria crit;
            String name = entry.getKey();
            Object inputValue = entry.getValue();
            if (inputValue instanceof Collection) {
                Collection optionValues = (Collection)inputValue;
                crit = this.convertMultiValuedEntry(name, optionValues);
                res.put(name, crit);
                continue;
            }
            if (inputValue instanceof Map) {
                Map map = (Map)inputValue;
                crit = this.convertSimpleEntry(name, map);
                res.put(name, crit);
                continue;
            }
            LOGGER.error("Form {} contains non convertible entry {}", formValues, entry);
            throw new FormEntryNotConvertibleException(entry);
        }
        return res;
    }

    private Criteria convertMultiValuedEntry(String name, Collection<Map<String, Object>> multiValued) {
        InputType inputType = this.extractInputType(multiValued);
        return this.convertMultiValuedEntry(name, multiValued, inputType);
    }

    /*
     * Exception decompiling
     */
    private Criteria convertMultiValuedEntry(String name, Collection<Map<String, Object>> multiValued, InputType inputType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Criteria createTagCriteria(String name, Collection<Map<String, Object>> multiValued, InputType inputType) {
        MultiOptionsCriteria crit = new MultiOptionsCriteria(name, inputType);
        for (Map<String, Object> valueItem : multiValued) {
            Collection tags = (Collection)valueItem.get(INPUT_VALUE);
            for (String tag : tags) {
                crit.addOption((Object)tag, Boolean.TRUE.booleanValue());
            }
        }
        return crit;
    }

    private Criteria createNodeMapCriteria(String name, Collection<Map<String, Object>> multiValued, InputType inputType) {
        MultiValuesCriteria crit = new MultiValuesCriteria(name, inputType);
        for (Map<String, Object> valueItem : multiValued) {
            String nodeType = (String)valueItem.get("nodeType");
            Object value = valueItem.get(INPUT_VALUE);
            crit.addValue(nodeType, value);
        }
        return crit;
    }

    private Criteria createSingleOptionCriteria(String name, Collection<Map<String, Object>> multiValued, InputType inputType) {
        for (Map<String, Object> valueItem : multiValued) {
            Boolean selected = (Boolean)valueItem.get(INPUT_SELECTED);
            if (!selected.booleanValue()) continue;
            return new SimpleCriteria(name, (Object)((String)valueItem.get(INPUT_VALUE)), inputType);
        }
        return new EmptyCriteria(name, inputType);
    }

    private Criteria createMultiOptionsCriteria(String name, Collection<Map<String, Object>> multiValued, InputType inputType) {
        MultiOptionsCriteria crit = new MultiOptionsCriteria(name, inputType);
        for (Map<String, Object> valueItem : multiValued) {
            Boolean selected = (Boolean)valueItem.get(INPUT_SELECTED);
            Object value = valueItem.get(INPUT_VALUE);
            crit.addOption(value, selected.booleanValue());
        }
        return crit;
    }

    private Criteria createMilestoneMultiCriteria(String name, Collection<Map<String, Object>> multiValued, InputType inputType) {
        MultiOptionsCriteria crit = new MultiOptionsCriteria(name, inputType);
        for (Map<String, Object> valueItem : multiValued) {
            Collection selectedIds = (Collection)valueItem.get(INPUT_VALUE);
            for (Integer id : selectedIds) {
                crit.addOption((Object)id, Boolean.TRUE.booleanValue());
            }
        }
        return crit;
    }

    private InputType extractInputType(Collection<Map<String, Object>> multiValued) {
        String type = null;
        for (Map<String, Object> valueItem : multiValued) {
            if (type == null) {
                type = (String)valueItem.get(INPUT_TYPE);
                continue;
            }
            if (type.equals(valueItem.get(INPUT_TYPE))) continue;
            throw new InconsistentMultiValuedEntryException(multiValued);
        }
        return InputType.valueOf(type);
    }

    private Criteria convertSimpleEntry(String name, Map<String, Object> entry) {
        String type = (String)entry.get(INPUT_TYPE);
        InputType inputType = InputType.valueOf((String)type);
        return this.simpleEntryConverter(inputType).convertEntry(name, entry, inputType);
    }

    private SimpleEntryConverter simpleEntryConverter(InputType type) {
        SimpleEntryConverter converter = (SimpleEntryConverter)this.simpleEntryConverterByType.get(type);
        if (converter == null) {
            converter = this.simpleEntryDefaultConverter;
        }
        return converter;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$api$report$form$InputType() {
        if ($SWITCH_TABLE$org$squashtest$tm$api$report$form$InputType != null) {
            return $SWITCH_TABLE$org$squashtest$tm$api$report$form$InputType;
        }
        int[] nArray = new int[InputType.values().length];
        try {
            nArray[InputType.CHECKBOX.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.CHECKBOXES_GROUP.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.DATE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.DROPDOWN_LIST.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.INPUTS_GROUP.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.LABEL.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.MILESTONE_PICKER.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.PASSWORD.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.PROJECT_PICKER.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.RADIO_BUTTONS_GROUP.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.TAG_PICKER.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.TEMPLATE_DROPDOWN_LIST.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.TEXT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[InputType.TREE_PICKER.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$squashtest$tm$api$report$form$InputType = nArray;
        return nArray;
    }
}

