/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.thirdpartyserver;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class UriUtils {
    private static final Map<String, Integer> DEFAULT_PORTS;
    private static final Logger LOGGER;

    static {
        LOGGER = LoggerFactory.getLogger(UriUtils.class);
        DEFAULT_PORTS = new HashMap(3);
        DEFAULT_PORTS.put("ftp", 23);
        DEFAULT_PORTS.put("http", 80);
        DEFAULT_PORTS.put("https", 443);
    }

    private UriUtils() {
    }

    public static String extractPath(HttpServletRequest request, String uriPrefix, String uriSuffix) {
        String requestUri = request.getRequestURI();
        String pattern = "/" + uriPrefix + "/(.*)" + uriSuffix;
        LOGGER.trace("Trying to extract path from URI " + requestUri + " using pattern " + pattern);
        Matcher matcher = Pattern.compile(pattern).matcher(requestUri);
        matcher.find();
        String path = matcher.group(1);
        LOGGER.trace("Path extracted = " + path);
        return path;
    }

    public static String extractBaseUrl(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort());
        sb.append(request.getContextPath());
        String url = sb.toString();
        return UriUtils.canonicalize((String)url);
    }

    public static final String canonicalize(String strUrl) {
        try {
            URIBuilder builder = new URIBuilder(strUrl);
            String scheme = builder.getScheme();
            if (scheme != null) {
                scheme = scheme.toLowerCase();
                builder.setScheme(scheme);
                Integer port = (Integer)DEFAULT_PORTS.get(scheme);
                if (port != null && port.intValue() == builder.getPort()) {
                    builder.setPort(-1);
                }
            }
            if (builder.getHost() != null) {
                builder.setHost(builder.getHost().toLowerCase());
            }
            return builder.toString();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }
}

