/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.orchestrator;

import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.internal.dto.WorkflowDto;
import org.squashtest.tm.service.orchestrator.OrchestratorOperationService;
import org.squashtest.tm.service.orchestrator.model.OrchestratorConfVersions;
import org.squashtest.tm.service.orchestrator.model.OrchestratorResponse;

@Controller
@RequestMapping(value={"/backend/orchestrator-operation/{testAutomationServerId}/"})
public class OrchestratorOperationController {
    private final OrchestratorOperationService orchestratorOperationService;

    public OrchestratorOperationController(OrchestratorOperationService orchestratorOperationService) {
        this.orchestratorOperationService = orchestratorOperationService;
    }

    @GetMapping(value={"/orchestrator-configuration"})
    @ResponseBody
    public OrchestratorResponse<OrchestratorConfVersions> getOrchestratorConfiguration(@PathVariable Long testAutomationServerId) {
        return this.orchestratorOperationService.getOrchestratorConfVersions(testAutomationServerId);
    }

    @GetMapping(value={"/project/{projectId}/workflows"})
    @ResponseBody
    public OrchestratorResponse<List<WorkflowDto>> getProjectWorkflows(@PathVariable Long projectId, @PathVariable Long testAutomationServerId) {
        return this.orchestratorOperationService.getProjectWorkflows(testAutomationServerId, projectId);
    }
}

