/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.attachment;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.display.attachment.FileViewerService;
import org.squashtest.tm.service.internal.display.attachment.FileViewerExtension;
import org.squashtest.tm.service.internal.display.dto.FileViewerDto;

@RestController
@RequestMapping(value={"backend/file-viewer"})
public class FileViewerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileViewerController.class);
    private static final String FILE_PATH = "filePath";
    private static final String ERROR_MESSAGE = "An error occurred while viewing the attachment : ";
    private static final String ATTACHMENT_FILENAME = "attachment; filename=";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private FileViewerService fileViewerService;

    @GetMapping(value={"/preview/file"}, params={"filePath"})
    public void previewFile(@RequestParam(value="filePath") String filePath, HttpServletResponse response) {
        File file = new File(filePath);
        String formattedName = file.getName().replace(" ", "_");
        String fileExtension = FilenameUtils.getExtension((String)formattedName);
        try {
            FileViewerExtension fileType = Arrays.stream(FileViewerExtension.values()).filter(extension -> extension.name().equalsIgnoreCase(fileExtension)).findAny().orElse(null);
            if (Objects.nonNull(fileType)) {
                FileViewerDto fileViewer = this.fileViewerService.preview(filePath, fileType, false);
                this.displayPreview(response, fileViewer, formattedName);
            }
        }
        catch (IOException e) {
            LOGGER.warn(ERROR_MESSAGE + e.getMessage(), (Throwable)e);
            response.setStatus(500);
        }
    }

    @GetMapping(value={"/download/file"}, params={"filePath"})
    @ResponseBody
    public FileSystemResource downloadFile(@RequestParam(value="filePath") String filePath, HttpServletResponse response) {
        File logfile = new File(filePath);
        response.setContentType("application/octet-stream");
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + logfile.getName());
        return new FileSystemResource(logfile);
    }

    @GetMapping(value={"/attachment/{attachmentId}/{attachmentName}"})
    public void previewAttachment(@PathVariable(value="attachmentId") Long attachmentId, @PathVariable(value="attachmentName") String attachmentName, HttpServletResponse response) {
        try {
            Attachment attachment = this.attachmentManagerService.findAttachment(attachmentId);
            String formattedName = attachmentName.replace(" ", "_");
            FileViewerExtension fileType = Arrays.stream(FileViewerExtension.values()).filter(extension -> extension.name().equalsIgnoreCase(attachment.getType())).findAny().orElse(null);
            if (Objects.nonNull(fileType)) {
                FileViewerDto fileViewer = this.fileViewerService.preview(attachmentId.toString(), fileType, true);
                this.displayPreview(response, fileViewer, formattedName);
            } else {
                LOGGER.info("Unable to view the attachment : " + attachmentName + ". The file extension " + attachment.getType() + " is not supported." + " The attachment will be automatically downloaded.");
                this.downloadAttachment(attachmentId.longValue(), response, formattedName);
            }
        }
        catch (IOException e) {
            LOGGER.warn(ERROR_MESSAGE + e.getMessage(), (Throwable)e);
            response.setStatus(500);
        }
        catch (IllegalArgumentException | AccessDeniedException e) {
            LOGGER.warn(ERROR_MESSAGE + e.getMessage(), e);
            response.setStatus(404);
        }
    }

    private void displayPreview(HttpServletResponse response, FileViewerDto fileViewer, String formattedName) throws IOException {
        response.setHeader(CONTENT_DISPOSITION, "inline; filename=" + formattedName);
        response.setContentType(fileViewer.getType().media);
        response.setCharacterEncoding(Charset.defaultCharset().name());
        if (fileViewer.getType().isOutputStream) {
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write((byte[])fileViewer.getContent());
        } else {
            PrintWriter writer = response.getWriter();
            writer.print(fileViewer.getContent());
            writer.flush();
        }
    }

    private void downloadAttachment(long attachmentId, HttpServletResponse response, String formattedName) throws IOException {
        response.setContentType("application/octet-stream");
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + formattedName);
        ServletOutputStream outStream = response.getOutputStream();
        this.attachmentManagerService.writeContent(attachmentId, (OutputStream)outStream);
    }
}

