/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportDashboardDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.web.backend.controller.testcase.TestCaseMilestoneDashboardController;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/test-case-milestone-dashboard"})
public class TestCaseMilestoneDashboardController {
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;
    private final CustomReportDashboardService customReportDashboardService;
    private final PartyPreferenceService partyPreferenceService;

    public TestCaseMilestoneDashboardController(TestCaseLibraryNavigationService testCaseLibraryNavigationService, ActiveMilestoneHolder activeMilestoneHolder, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider, CustomReportDashboardService customReportDashboardService, PartyPreferenceService partyPreferenceService) {
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
        this.customReportDashboardService = customReportDashboardService;
        this.partyPreferenceService = partyPreferenceService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public TestCaseMilestoneDashboard getDashboardByMilestone(Locale locale) {
        TestCaseMilestoneDashboard testCaseMilestoneDashboard = new TestCaseMilestoneDashboard();
        boolean canShowDashboardInWorkspace = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.TEST_CASE);
        boolean shouldShowFavoriteDashboardInWorkspace = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.TEST_CASE);
        testCaseMilestoneDashboard.setCanShowFavoriteDashboard(canShowDashboardInWorkspace);
        testCaseMilestoneDashboard.setShouldShowFavoriteDashboard(shouldShowFavoriteDashboardInWorkspace);
        if (shouldShowFavoriteDashboardInWorkspace) {
            if (canShowDashboardInWorkspace) {
                PartyPreference preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_TEST_CASE.getPreferenceKey());
                CustomReportDashboardDto dashboardDto = new CustomReportDashboardDto(Workspace.REQUIREMENT, Collections.emptyList(), true);
                Long dashboardId = Long.valueOf(preference.getPreferenceValue());
                CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(dashboardId);
                JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dashboardId, dashboard, locale, dashboardDto);
                testCaseMilestoneDashboard.setDashboard(jsonDashboard);
                testCaseMilestoneDashboard.setFavoriteDashboardId(dashboardId);
            }
        } else {
            Milestone activeMilestone = this.activeMilestoneHolder.getActiveMilestone().orElse(null);
            List nodeIds = this.testCaseLibraryNavigationService.findAllTestCasesLibraryNodeForMilestone(activeMilestone);
            testCaseMilestoneDashboard.setStatistics(this.testCaseLibraryNavigationService.getStatisticsForSelection(new ArrayList(), (Collection)nodeIds));
        }
        return testCaseMilestoneDashboard;
    }
}

