/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.navigation;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.service.deletion.Node;
import org.squashtest.tm.service.deletion.NodeMovement;
import org.squashtest.tm.service.deletion.NodeReferenceChanged;
import org.squashtest.tm.service.deletion.NodeRenaming;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.display.workspace.tree.TreeBrowser;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;
import org.squashtest.tm.service.internal.display.grid.TreeRequest;
import org.squashtest.tm.service.library.LibraryNavigationService;
import org.squashtest.tm.web.backend.controller.form.model.RefreshTreeNodeModel;
import org.squashtest.tm.web.backend.controller.navigation.Messages;

public abstract class AbstractLibraryNavigationController<LIBRARY extends Library<? extends NODE>, FOLDER extends Folder<? extends NODE>, NODE extends LibraryNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLibraryNavigationController.class);
    protected final TreeBrowser treeBrowser;
    protected final MessageSource messageSource;

    protected AbstractLibraryNavigationController(TreeBrowser treeBrowser, MessageSource messageSource) {
        this.treeBrowser = treeBrowser;
        this.messageSource = messageSource;
    }

    @RequestMapping(method={RequestMethod.POST})
    public TreeGridResponse getInitialRows(@RequestBody TreeRequest treeRequest) {
        return this.treeBrowser.getInitialTree(this.getWorkspace(), NodeReference.fromNodeIds((Collection)treeRequest.getOpenedNodes()), NodeReference.fromNodeIds((Collection)treeRequest.getSelectedNodes()));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{ids}/content"})
    public TreeGridResponse getChildren(@PathVariable List<String> ids) {
        Set nodeReference = NodeReference.fromNodeIds(ids);
        return this.treeBrowser.findSubHierarchy(nodeReference, new HashSet(nodeReference));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/refresh"})
    public TreeGridResponse refreshNodes(@RequestBody RefreshTreeNodeModel refreshTreeNodeModel) {
        return this.treeBrowser.findSubHierarchy(NodeReference.fromNodeIds((Collection)refreshTreeNodeModel.getNodeIds()), new HashSet(refreshTreeNodeModel.getNodeList().getNodeReferences()));
    }

    protected abstract LibraryNavigationService<LIBRARY, FOLDER, NODE> getLibraryNavigationService();

    protected abstract NodeWorkspace getWorkspace();

    @ResponseBody
    @RequestMapping(value={"/deletion-simulation/{nodeIds}"}, method={RequestMethod.GET})
    public Messages simulateNodeDeletion(@PathVariable(value="nodeIds") List<Long> nodeIds, Locale locale) {
        List reportList = this.getLibraryNavigationService().simulateDeletion(nodeIds);
        Messages messages = new Messages();
        for (SuppressionPreviewReport report : reportList) {
            messages.addMessage(report.toString(this.messageSource, locale));
        }
        return messages;
    }

    @ResponseBody
    @RequestMapping(value={"/{nodeIds}"}, method={RequestMethod.DELETE})
    public OperationReport confirmNodeDeletion(@PathVariable(value="nodeIds") List<Long> nodeIds) {
        OperationReport report = this.getLibraryNavigationService().deleteNodes(nodeIds);
        this.logOperations(report);
        return report;
    }

    protected void logOperations(OperationReport report) {
        for (Node deletedNode : report.getRemoved()) {
            LOGGER.info("The node #{} was removed", (Object)deletedNode.getResid());
        }
        for (NodeMovement movedNode : report.getMoved()) {
            LOGGER.info("The nodes #{} were moved to node #{}", movedNode.getMoved().stream().map(Node::getResid).collect(Collectors.toList()), (Object)movedNode.getDest().getResid());
        }
        for (NodeRenaming renamedNode : report.getRenamed()) {
            LOGGER.info("The node #{} was renamed to {}", (Object)renamedNode.getNode().getResid(), (Object)renamedNode.getName());
        }
        for (NodeReferenceChanged nodeReferenceChanged : report.getReferenceChanges()) {
            LOGGER.info("The node #{} reference was changed to {}", (Object)nodeReferenceChanged.getNode().getResid(), (Object)nodeReferenceChanged.getReference());
        }
    }
}

