/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import javax.inject.Inject;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.campaign.TestPlanOwner;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.exception.execution.TestPlanTerminatedOrNoStepsException;
import org.squashtest.tm.service.campaign.EntityFinder;
import org.squashtest.tm.service.campaign.TestPlanExecutionProcessingService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;

public abstract class AbstractTestPlanExecutionRunnerController<E extends TestPlanOwner> {
    @Inject
    protected TestPlanExecutionProcessingService<E> testPlanExecutionRunner;
    @Inject
    protected ExecutionProcessingService executionRunner;
    @Inject
    EntityFinder<E> entityFinder;

    public Execution startResume(long testPlanOwnerId) {
        boolean hasDeletedTestCaseInTestPlan = this.hasDeletedTestCaseInTestPlan(testPlanOwnerId);
        if (!hasDeletedTestCaseInTestPlan) {
            try {
                return this.testPlanExecutionRunner.startResume(testPlanOwnerId);
            }
            catch (TestPlanItemNotExecutableException e) {
                throw new TestPlanTerminatedOrNoStepsException((Exception)((Object)e));
            }
        }
        throw this.getTestPlanHasDeletedTestCaseException();
    }

    public Execution relaunch(long testPlanOwnerId) {
        boolean hasDeletedTestCaseInTestPlan = this.hasDeletedTestCaseInTestPlan(testPlanOwnerId);
        if (!hasDeletedTestCaseInTestPlan) {
            try {
                return this.testPlanExecutionRunner.relaunch(testPlanOwnerId);
            }
            catch (TestPlanItemNotExecutableException e) {
                throw new TestPlanTerminatedOrNoStepsException((Exception)((Object)e));
            }
        }
        throw this.getTestPlanHasDeletedTestCaseException();
    }

    abstract ActionException getTestPlanHasDeletedTestCaseException();

    abstract boolean hasDeletedTestCaseInTestPlan(long var1);
}

