/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.config;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.grid.GridConfigurationService;
import org.squashtest.tm.service.internal.dto.GridColumnConfigDto;

@Controller
@RequestMapping(value={"/backend/grid"})
public class GridConfigurationController {
    @Inject
    private GridConfigurationService gridConfigurationService;

    @PostMapping(value={"/update-column-config"})
    @ResponseBody
    public void updateGridColumnConfig(@RequestBody GridColumnConfigDto request) {
        this.gridConfigurationService.addOrUpdatePreferenceForCurrentUser(request.getGridId(), request.getActiveColumnIds());
    }

    @PostMapping(value={"/update-column-config-with-project"})
    @ResponseBody
    public void updateGridColumnConfigWithProject(@RequestBody GridColumnConfigDto request) {
        this.gridConfigurationService.addOrUpdatePreferenceForCurrentUserWithProjectId(request.getGridId(), request.getActiveColumnIds(), request.getProjectId());
    }

    @DeleteMapping(value={"/{gridId}/reset-column-config"})
    @ResponseBody
    public void resetGridColumnConfig(@PathVariable String gridId) {
        this.gridConfigurationService.resetGridColumnConfig(gridId);
    }

    @DeleteMapping(value={"/{gridId}/reset-column-config-with-project/{projectId}"})
    @ResponseBody
    public void resetGridColumnConfigWithProjectId(@PathVariable String gridId, @PathVariable String projectId) {
        this.gridConfigurationService.resetGridColumnConfigWithProjectId(gridId, projectId);
    }

    @PostMapping(value={"/get-column-config"})
    @ResponseBody
    public List<String> getGridColumnConfig(@RequestBody GridColumnConfigDto request) {
        return this.gridConfigurationService.findActiveColumnIdsForUser(request.getGridId());
    }

    @PostMapping(value={"/get-column-config-with-project"})
    @ResponseBody
    public List<String> getGridColumnConfigWithProject(@RequestBody GridColumnConfigDto request) {
        return this.gridConfigurationService.findActiveColumnIdsForUserWithProjectId(request.getGridId(), request.getProjectId());
    }
}

