/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.Collections;
import java.util.Locale;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.campaign.CampaignDisplayService;
import org.squashtest.tm.service.internal.display.dto.campaign.CampaignFolderDto;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportDashboardDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.statistics.campaign.StatisticsBundle;
import org.squashtest.tm.web.backend.controller.campaign.CampaignViewController;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/campaign-folder-view"})
public class CampaignFolderViewController {
    private CampaignDisplayService campaignDisplayService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;
    private CampaignLibraryNavigationService campaignLibraryNavigationService;

    public CampaignFolderViewController(CampaignDisplayService campaignDisplayService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider, CampaignLibraryNavigationService campaignLibraryNavigationService) {
        this.campaignDisplayService = campaignDisplayService;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
    }

    @GetMapping(value={"/{campaignFolderId}"})
    public CampaignFolderDto getCampaignFolderView(@PathVariable long campaignFolderId, Locale locale) {
        CampaignFolderDto dto = this.campaignDisplayService.getCampaignFolderView(campaignFolderId);
        if (dto.isShouldShowFavoriteDashboard() && dto.isCanShowFavoriteDashboard()) {
            EntityReference library = new EntityReference(EntityType.CAMPAIGN_FOLDER, Long.valueOf(campaignFolderId));
            CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(dto.getFavoriteDashboardId());
            CustomReportDashboardDto dashboardScopeDto = new CustomReportDashboardDto(Workspace.CAMPAIGN, Collections.singletonList(library), false, false, true);
            JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dto.getFavoriteDashboardId(), dashboard, locale, dashboardScopeDto);
            dto.setDashboard(jsonDashboard);
        }
        return dto;
    }

    @PostMapping(value={"/{campaignFolderId}/statistics"})
    public StatisticsBundle getCampaignFolderStatistics(@PathVariable long campaignFolderId, @RequestBody CampaignViewController.StatisticsScopePatch patch) {
        return this.campaignLibraryNavigationService.gatherFolderStatisticsBundle(Long.valueOf(campaignFolderId), patch.lastExecutionScope());
    }
}

