/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.security.authentication;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.task.TaskExecutor;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.servers.UserCredentialsCache;
import org.squashtest.tm.web.backend.security.authentication.BugTrackerAutoconnectCallback;

@Component
public class BugTrackerAutoconnectCallback
implements ApplicationListener<InteractiveAuthenticationSuccessEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BugTrackerAutoconnectCallback.class);
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private FeatureManager featureManager;
    @Inject
    private Provider<AsynchronousBugTrackerAutoconnect> asyncProvider;

    public void onApplicationEvent(InteractiveAuthenticationSuccessEvent event) {
        Authentication authentication = event.getAuthentication();
        HttpSession session = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getSession();
        UserCredentialsCache credentialsCache = this.initializeCredentialsCache(authentication.getName(), session);
        this.scheduleAutoconnection(authentication, credentialsCache);
    }

    private UserCredentialsCache initializeCredentialsCache(String username, HttpSession session) {
        LOGGER.debug("BugTrackerAutoconnectCallback : initializing the credentials cache");
        UserCredentialsCache credentials = new UserCredentialsCache(username, this.featureManager);
        session.setAttribute("squashtest.servers.UserCredentialsCache", (Object)credentials);
        this.credentialsProvider.restoreCache(credentials);
        return credentials;
    }

    private void scheduleAutoconnection(Authentication authentication, UserCredentialsCache credentialsCache) {
        LOGGER.debug("BugTrackerAutoconnectCallback : scheduling autoconnection for user '{}'", (Object)credentialsCache.getUser());
        AsynchronousBugTrackerAutoconnect autoconnector = (AsynchronousBugTrackerAutoconnect)this.asyncProvider.get();
        autoconnector.setUser(authentication.getName());
        autoconnector.setSpringsecCredentials(authentication.getCredentials());
        autoconnector.setCredentialsCache(credentialsCache);
        this.taskExecutor.execute((Runnable)autoconnector);
    }
}

