/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.security.authentication;

import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.squashtest.tm.api.security.authentication.AuthenticationProviderFeatures;
import org.squashtest.tm.service.internal.security.AuthenticationProviderContext;
import org.squashtest.tm.service.plugin.PluginFinderService;
import org.squashtest.tm.service.security.AuthenticatedMissingUserCreatorService;
import org.squashtest.tm.service.security.OidcUserCreatorService;
import org.squashtest.tm.web.backend.context.ApplicationComponent;

@ApplicationComponent
public class AuthenticatedMissingUserCreator
implements ApplicationListener<AuthenticationSuccessEvent>,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticatedMissingUserCreator.class);
    @Inject
    private AuthenticationProviderContext authProviderContext;
    @Inject
    private AuthenticatedMissingUserCreatorService authenticatedMissingUserCreatorService;
    @Autowired(required=false)
    OidcUserCreatorService oidcUserCreatorService;
    @Inject
    PluginFinderService pluginFinderService;

    public AuthenticatedMissingUserCreator() {
        LOGGER.info("created");
    }

    public int getOrder() {
        return -2147483647;
    }

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        AuthenticationProviderFeatures features = this.authProviderContext.getProviderFeatures(event.getAuthentication());
        if (features.shouldCreateMissingUser()) {
            this.authenticatedMissingUserCreatorService.createMissingUser(event.getAuthentication());
        } else if (event.getAuthentication() instanceof OAuth2LoginAuthenticationToken && this.pluginFinderService.isOpenIdConnectPluginInstalled()) {
            this.oidcUserCreatorService.createMissingSquashUser(event.getAuthentication());
        }
    }
}

