/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.manager.export;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.map.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.squashtest.tm.annotation.WebComponent;
import org.squashtest.tm.api.export.ExportPlugin;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.web.backend.manager.export.ExportPluginManager;

@WebComponent
public class ExportPluginManagerImpl
implements ExportPluginManager {
    @Autowired(required=false)
    private Collection<ExportPlugin> plugins = Collections.emptyList();
    private final MultiValueMap pluginsByWorkspace = new MultiValueMap();

    @PostConstruct
    public void registerPlugins() {
        for (ExportPlugin plugin : this.plugins) {
            this.pluginsByWorkspace.put((Object)plugin.getDisplayWorkspace(), (Object)plugin);
        }
    }

    public Collection<ExportPlugin> findAllByWorkspace(WorkspaceType workspace) {
        Set allPlugins = this.pluginsByWorkspace.getCollection((Object)workspace);
        if (allPlugins == null) {
            allPlugins = Collections.emptySet();
        }
        return Collections.unmodifiableCollection(allPlugins);
    }
}

