/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.fileupload;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.squashtest.tm.event.ConfigUpdateEvent;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.web.backend.fileupload.SquashMultipartResolver;

public class MultipartResolverDispatcher
extends CommonsMultipartResolver {
    private SquashMultipartResolver defaultResolver;
    private Map<String, SquashMultipartResolver> resolverMap;
    private ConfigurationService confService;

    public void setResolverMap(Map<String, SquashMultipartResolver> chain) {
        this.resolverMap = chain;
    }

    public void setDefaultResolver(SquashMultipartResolver defaultResolver) {
        this.defaultResolver = defaultResolver;
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        String target = request.getRequestURI();
        for (Map.Entry resolverEntry : this.resolverMap.entrySet()) {
            if (!target.matches((String)resolverEntry.getKey())) continue;
            return ((SquashMultipartResolver)resolverEntry.getValue()).resolveMultipart(request);
        }
        return this.defaultResolver.resolveMultipart(request);
    }

    @EventListener
    public void onContextReady(ContextRefreshedEvent event) {
        if (this.confService == null) {
            this.confService = (ConfigurationService)event.getApplicationContext().getBean(ConfigurationService.class);
            for (SquashMultipartResolver resolver : this.resolverMap.values()) {
                resolver.setConfigurationService(this.confService);
                resolver.updateConfig();
            }
        }
    }

    @EventListener
    public void onConfigChange(ConfigUpdateEvent update) {
        for (SquashMultipartResolver resolver : this.resolverMap.values()) {
            resolver.updateConfig();
        }
    }
}

