/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.web.backend.exceptionresolver.model.FieldValidationErrorModel;
import org.squashtest.tm.web.backend.exceptionresolver.model.SquashFieldValidationErrorModel;

@Component
public class MethodArgumentNotValidExceptionHandler
extends AbstractHandlerExceptionResolver {
    public MethodArgumentNotValidExceptionHandler() {
        this.setOrder(Integer.MIN_VALUE);
    }

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex)) {
            return this.handleException(response, ex);
        }
        return null;
    }

    private ModelAndView handleException(HttpServletResponse response, Exception ex) {
        MethodArgumentNotValidException invalidAgrumentEx = (MethodArgumentNotValidException)ex;
        response.setStatus(412);
        List errors = this.buildFieldValidationErrors(invalidAgrumentEx);
        return new ModelAndView((View)new MappingJackson2JsonView(), "squashTMError", (Object)new SquashFieldValidationErrorModel(errors));
    }

    private List<FieldValidationErrorModel> buildFieldValidationErrors(MethodArgumentNotValidException invalidAgrumentEx) {
        ArrayList<FieldValidationErrorModel> ves = new ArrayList<FieldValidationErrorModel>();
        List oes = invalidAgrumentEx.getBindingResult().getFieldErrors();
        for (FieldError oe : oes) {
            ves.add(new FieldValidationErrorModel(oe.getObjectName(), oe.getField(), oe.getDefaultMessage()));
        }
        return ves;
    }

    private boolean exceptionIsHandled(Exception ex) {
        return MethodArgumentNotValidException.class.isAssignableFrom(ex.getClass());
    }
}

