/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase;

import java.util.Collection;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.internal.display.dto.AutomatedTestDto;
import org.squashtest.tm.service.internal.display.grid.TreeGridResponse;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.web.backend.controller.testcase.TestCaseAutomationController;
import org.squashtest.tm.web.backend.model.testautomation.TATestFlatTree;
import org.squashtest.tm.web.backend.model.testautomation.TATestNodeListBuilder;

@Controller
@RequestMapping(value={"backend/test-case/{testCaseId}/test-automation"})
public class TestCaseAutomationController {
    private TestCaseModificationService testCaseModificationService;

    public TestCaseAutomationController(TestCaseModificationService testCaseModificationService) {
        this.testCaseModificationService = testCaseModificationService;
    }

    @ResponseBody
    @GetMapping(value={"/tests"})
    public TreeGridResponse findAssignableAutomatedTests(@PathVariable Long testCaseId) {
        Collection list = this.testCaseModificationService.findAssignableAutomationTests(testCaseId.longValue());
        Collection nodes = new TATestNodeListBuilder().build(list);
        return new TATestFlatTree().flatTree(nodes);
    }

    @PostMapping(value={"/tests"})
    @ResponseBody
    public AutomatedTestDto bindAutomatedTest(@PathVariable Long testCaseId, @RequestBody AutomatedTestPatch automatedTestPatch) {
        return this.testCaseModificationService.bindAutomatedTestToTC(testCaseId, automatedTestPatch.path);
    }
}

