/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.search;

import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.service.display.search.CampaignSearchGridDisplayService;
import org.squashtest.tm.service.display.search.CampaignSearchInputData;
import org.squashtest.tm.service.display.search.CampaignSearchInputDataProvider;
import org.squashtest.tm.service.display.search.CampaignSearchService;
import org.squashtest.tm.service.display.search.ResearchResult;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;

@RestController
@RequestMapping(value={"backend/search/campaign"})
public class CampaignSearchController {
    private final CampaignSearchInputDataProvider inputDataProvider;
    private final CampaignSearchService campaignSearchService;
    private final CampaignSearchGridDisplayService campaignSearchGridDisplayService;

    public CampaignSearchController(CampaignSearchInputDataProvider inputDataProvider, CampaignSearchService campaignSearchService, CampaignSearchGridDisplayService campaignSearchGridDisplayService) {
        this.inputDataProvider = inputDataProvider;
        this.campaignSearchService = campaignSearchService;
        this.campaignSearchGridDisplayService = campaignSearchGridDisplayService;
    }

    @GetMapping
    public CampaignSearchInputData getSearchInputData() {
        return this.inputDataProvider.provide();
    }

    @PostMapping
    public GridResponse search(@RequestBody GridRequest gridRequest) {
        List<String> testSuites = gridRequest.getScope().stream().filter(scope -> scope.contains(EntityType.TEST_SUITE.getSimpleClassName())).toList();
        List<String> scopeWithoutTestSuites = gridRequest.getScope().stream().filter(scope -> !scope.contains(EntityType.TEST_SUITE.getSimpleClassName())).toList();
        if (!testSuites.isEmpty() && !scopeWithoutTestSuites.isEmpty()) {
            gridRequest.setScope(scopeWithoutTestSuites);
            gridRequest.setExcludedScope(testSuites);
            GridResponse searchWithoutTestSuiteResult = this.doSearch(gridRequest);
            gridRequest.setScope(new ArrayList());
            this.createFilterValueOnTestSuiteIds(gridRequest, testSuites);
            GridResponse testSuiteSearchResult = this.doSearch(gridRequest);
            return this.combineMultipleSearchResultsIntoGridResponse(searchWithoutTestSuiteResult, testSuiteSearchResult);
        }
        if (!testSuites.isEmpty()) {
            this.createFilterValueOnTestSuiteIds(gridRequest, testSuites);
            return this.doSearch(gridRequest);
        }
        return this.doSearch(gridRequest);
    }

    private GridResponse doSearch(GridRequest gridRequest) {
        ResearchResult researchResult = this.campaignSearchService.search(gridRequest);
        return this.campaignSearchGridDisplayService.fetchResearchRows(researchResult, gridRequest);
    }

    private GridResponse combineMultipleSearchResultsIntoGridResponse(GridResponse firstSearchResult, GridResponse testSuiteSearchResult) {
        List allSearchDataRows = firstSearchResult.getDataRows();
        allSearchDataRows.addAll(testSuiteSearchResult.getDataRows());
        firstSearchResult.setDataRows(allSearchDataRows);
        firstSearchResult.setCount(firstSearchResult.getCount() + testSuiteSearchResult.getCount());
        return firstSearchResult;
    }

    private void createFilterValueOnTestSuiteIds(GridRequest gridRequest, List<String> testSuites) {
        List<String> testSuitesIds = testSuites.stream().map(EntityReference::fromNodeId).map(EntityReference::getId).map(String::valueOf).toList();
        GridFilterValue gridFilterValue = new GridFilterValue();
        gridFilterValue.setOperation(Operation.IN.name());
        gridFilterValue.setColumnPrototype("ITEM_SUITE_ID");
        gridFilterValue.setValues(testSuitesIds);
        gridRequest.getFilterValues().add(gridFilterValue);
        List<String> scopeWithoutTestSuites = gridRequest.getScope().stream().filter(scope -> !scope.contains(EntityType.TEST_SUITE.getSimpleClassName())).toList();
        gridRequest.setScope(scopeWithoutTestSuites);
        gridRequest.setExcludedScope(testSuites);
    }
}

