/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.environmentVariable;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.environmentvariable.EVBindableEntity;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingService;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingValueService;
import org.squashtest.tm.service.internal.display.dto.BoundEnvironmentVariableDto;
import org.squashtest.tm.web.backend.controller.environmentVariable.BoundEnvironmentVariableController;

@Controller
@RequestMapping(value={"/backend/bound-environment-variables"})
public class BoundEnvironmentVariableController {
    private static final String BOUND_ENVIRONMENT_VARIABLES = "boundEnvironmentVariables";
    private final EnvironmentVariableBindingService environmentVariableBindingService;
    private final EnvironmentVariableBindingValueService environmentVariableValueService;

    public BoundEnvironmentVariableController(EnvironmentVariableBindingService environmentVariableBindingService, EnvironmentVariableBindingValueService environmentVariableValueService) {
        this.environmentVariableBindingService = environmentVariableBindingService;
        this.environmentVariableValueService = environmentVariableValueService;
    }

    @ResponseBody
    @GetMapping(value={"test-automation-server/{serverId}"})
    public Map<String, List<BoundEnvironmentVariableDto>> getBoundEnvironmentVariableFromServer(@PathVariable Long serverId) {
        return Collections.singletonMap(BOUND_ENVIRONMENT_VARIABLES, this.environmentVariableBindingService.getBoundEnvironmentVariablesByEntity(serverId, EVBindableEntity.TEST_AUTOMATION_SERVER));
    }

    @ResponseBody
    @GetMapping(value={"project/{projectId}"})
    public Map<String, List<BoundEnvironmentVariableDto>> getBoundEnvironmentVariablesFromProject(@PathVariable Long projectId) {
        return Collections.singletonMap(BOUND_ENVIRONMENT_VARIABLES, this.environmentVariableBindingService.getBoundEnvironmentVariableFromProjectView(projectId));
    }

    @ResponseBody
    @PostMapping(value={"value"})
    public void editEnvironmentVariableValue(@RequestBody EnvironmentVariableValuePatch patch) {
        this.environmentVariableValueService.editEnvironmentVariableValue(patch.getBindingId(), patch.getValue());
    }

    @ResponseBody
    @PostMapping(value={"reset"})
    public Map<String, String> resetEnvironmentVariableDefaultValue(@RequestBody EnvironmentVariableValuePatch patch) {
        String defaultValue = this.environmentVariableValueService.resetDefaultValue(patch.getBindingId(), patch.getEntityType());
        return Collections.singletonMap("defaultValue", defaultValue);
    }

    @PostMapping(value={"/bind"})
    @ResponseBody
    public Map<String, List<BoundEnvironmentVariableDto>> bindEnvironmentVariables(@RequestBody EnvironmentVariableBindingPatch bindingPatch) {
        this.environmentVariableBindingService.createNewBindings(bindingPatch.getEntityId(), bindingPatch.getEntityType(), bindingPatch.getEnvironmentVariableIds());
        return Collections.singletonMap(BOUND_ENVIRONMENT_VARIABLES, this.getBoundEnvironmentVariables(bindingPatch.getEntityId(), bindingPatch.getEntityType()));
    }

    private List<BoundEnvironmentVariableDto> getBoundEnvironmentVariables(Long entityId, EVBindableEntity entityType) {
        if (EVBindableEntity.PROJECT.equals((Object)entityType)) {
            return this.environmentVariableBindingService.getBoundEnvironmentVariableFromProjectView(entityId);
        }
        return this.environmentVariableBindingService.getBoundEnvironmentVariablesByEntity(entityId, entityType);
    }

    @PostMapping(value={"/unbind"})
    @ResponseBody
    public void unbindEnvironmentVariables(@RequestBody EnvironmentVariableBindingPatch bindingPatch) {
        this.environmentVariableBindingService.unbind(bindingPatch.getEntityId(), bindingPatch.getEntityType(), bindingPatch.getEnvironmentVariableIds());
    }
}

