/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.clipboard;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.service.clipboard.ClipboardService;
import org.squashtest.tm.web.backend.controller.form.model.NodeList;

@RestController
@RequestMapping(path={"backend/clipboard"})
public class ClipboardController {
    private final ClipboardService clipboardService;

    public ClipboardController(ClipboardService clipboardService) {
        this.clipboardService = clipboardService;
    }

    @ResponseBody
    @PostMapping(value={"/copy"})
    public NodeList copyNodes(@RequestBody NodeList sourceNodeList) {
        List childrenList = this.clipboardService.copyNodes(sourceNodeList.getNodeReferences());
        List references = childrenList.stream().map(NodeReference::toNodeId).collect(Collectors.toList());
        NodeList nodeList = new NodeList();
        nodeList.setReferences(references);
        return nodeList;
    }
}

