/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.display.campaign.CampaignDisplayService;
import org.squashtest.tm.service.internal.display.dto.LibraryDto;
import org.squashtest.tm.service.statistics.campaign.StatisticsBundle;
import org.squashtest.tm.web.backend.controller.campaign.CampaignViewController;

@RestController
@RequestMapping(value={"/backend/campaign-library-view"})
public class CampaignLibraryViewController {
    private CampaignDisplayService campaignDisplayService;
    private CampaignLibraryNavigationService campaignLibraryNavigationService;

    public CampaignLibraryViewController(CampaignDisplayService campaignDisplayService, CampaignLibraryNavigationService campaignLibraryNavigationService) {
        this.campaignDisplayService = campaignDisplayService;
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
    }

    @GetMapping(value={"/{campaignLibraryId}"})
    public LibraryDto getCampaignView(@PathVariable long campaignLibraryId) {
        return this.campaignDisplayService.getCampaignLibraryView(campaignLibraryId);
    }

    @PostMapping(value={"/{campaignLibraryId}/statistics"})
    public StatisticsBundle getCampaignLibraryStatistics(@PathVariable long campaignLibraryId, @RequestBody CampaignViewController.StatisticsScopePatch patch) {
        return this.campaignLibraryNavigationService.gatherLibraryStatisticsBundle(campaignLibraryId, patch.lastExecutionScope());
    }
}

