/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.steps;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.dto.testcase.AddTestStepOperationReport;
import org.squashtest.tm.service.internal.display.dto.testcase.PasteTestStepOperationReport;
import org.squashtest.tm.service.internal.display.dto.testcase.TestStepDto;
import org.squashtest.tm.service.internal.display.testcase.parameter.TestCaseParameterOperationReport;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.web.backend.controller.testcase.steps.ActionStepFormModel;
import org.squashtest.tm.web.backend.controller.testcase.steps.KeywordTestStepModel;
import org.squashtest.tm.web.backend.controller.testcase.steps.TestCaseTestStepsController;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Controller
@RequestMapping(value={"/backend/test-cases/{testCaseId}/steps"})
public class TestCaseTestStepsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseTestStepsController.class);
    private static final String TEST_CASE = "test case ";
    private CallStepManagerService callStepManager;
    private TestCaseModificationService testCaseModificationService;
    private TestCaseDisplayService testCaseDisplayService;
    private InternationalizationHelper internationalizationHelper;

    public TestCaseTestStepsController(CallStepManagerService callStepManager, TestCaseModificationService testCaseModificationService, TestCaseDisplayService testCaseDisplayService, InternationalizationHelper internationalizationHelper) {
        this.callStepManager = callStepManager;
        this.testCaseModificationService = testCaseModificationService;
        this.testCaseDisplayService = testCaseDisplayService;
        this.internationalizationHelper = internationalizationHelper;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public AddTestStepOperationReport addActionTestStep(@RequestBody ActionStepFormModel stepModel, @PathVariable long testCaseId) {
        ActionTestStep step = stepModel.getActionTestStep();
        Map customFieldValues = stepModel.getCufs();
        int index = stepModel.getIndex();
        ActionTestStep actionTestStep = index != 0 ? this.testCaseModificationService.addActionTestStep(testCaseId, step, customFieldValues, index) : this.testCaseModificationService.addActionTestStep(testCaseId, step, customFieldValues);
        LOGGER.trace(TEST_CASE + testCaseId + ": step added, action : " + step.getAction() + ", expected result : " + step.getExpectedResult());
        TestStepDto dto = this.testCaseModificationService.findTestStep(actionTestStep.getId());
        TestCaseParameterOperationReport testCaseParameterOperationReport = this.testCaseDisplayService.findParametersDataByTestStepId(actionTestStep.getId());
        return new AddTestStepOperationReport(dto, testCaseParameterOperationReport);
    }

    @ResponseBody
    @PostMapping(value={"/add-keyword-test-step"})
    public AddTestStepOperationReport addKeywordTestStep(@RequestBody KeywordTestStepModel keywordTestStepDto, @PathVariable long testCaseId) throws BindException {
        this.validateDto(keywordTestStepDto);
        String keyword = keywordTestStepDto.getKeyword();
        String actionWord = keywordTestStepDto.getActionWord();
        int index = keywordTestStepDto.getIndex();
        Long newKeywordStepId = keywordTestStepDto.getActionWordId() != null ? this.addKeywordTestStepWithActionWordId(keywordTestStepDto, testCaseId) : (index != 0 ? this.testCaseModificationService.addKeywordTestStep(testCaseId, keyword, actionWord, index).getId() : this.testCaseModificationService.addKeywordTestStep(testCaseId, keyword, actionWord).getId());
        TestStepDto dto = this.testCaseModificationService.findTestStep(newKeywordStepId);
        TestCaseParameterOperationReport testCaseParameterOperationReport = this.testCaseDisplayService.findParametersDataByTestStepId(newKeywordStepId);
        return new AddTestStepOperationReport(dto, testCaseParameterOperationReport);
    }

    public Long addKeywordTestStepWithActionWordId(KeywordTestStepModel keywordTestStepDto, long testCaseId) throws BindException {
        this.validateDto(keywordTestStepDto);
        String keyword = keywordTestStepDto.getKeyword();
        String actionWord = keywordTestStepDto.getActionWord();
        int index = keywordTestStepDto.getIndex();
        long actionWordId = keywordTestStepDto.getActionWordId();
        KeywordTestStep step = this.testCaseModificationService.addKeywordTestStep(testCaseId, keyword, actionWord, Long.valueOf(actionWordId), index);
        return step.getId();
    }

    private void validateDto(KeywordTestStepModel keywordTestStepDto) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)keywordTestStepDto, "add-keyword-test-step");
        KeywordTestStepModel.KeywordTestStepModelValidator validator = new KeywordTestStepModel.KeywordTestStepModelValidator((MessageSource)this.internationalizationHelper);
        validator.validate((Object)keywordTestStepDto, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    @PostMapping(value={"/compare-keywords-projects"}, consumes={"application/json"})
    @ResponseBody
    public ResponseEntity<Boolean> compareKeywordProjectsIds(@RequestBody CopyStepModel copyStepModel, @PathVariable long testCaseId) {
        List copiedTestStepIds = copyStepModel.getCopiedStepIds();
        List copiedTestStepsProjectsIds = this.testCaseModificationService.fetchProjectsIdsByTestStepsIds(copiedTestStepIds);
        Long targetProjectId = this.testCaseModificationService.fetchTargetProjectId(Long.valueOf(testCaseId));
        return ResponseEntity.ok((Object)this.testCaseModificationService.areCopiedTestStepsProjectsIdsEqualToTargetProjectId(copiedTestStepsProjectsIds, targetProjectId));
    }

    @RequestMapping(value={"/paste"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public PasteTestStepOperationReport pasteSteps(@RequestBody CopyStepModel copyStepModel, @PathVariable long testCaseId) {
        List copiedStepIds = copyStepModel.getCopiedStepIds();
        this.callStepManager.checkForCyclicStepCallBeforePaste(testCaseId, copiedStepIds);
        PasteTestStepOperationReport pasteTestStepOperationReport = copyStepModel.targetTestStepId != null ? this.testCaseModificationService.pasteCopiedTestSteps(testCaseId, copyStepModel.getTargetTestStepId().longValue(), copiedStepIds, copyStepModel.isAssignedToTargetProject()) : this.testCaseModificationService.pasteCopiedTestStepToLastIndex(testCaseId, copiedStepIds, copyStepModel.isAssignedToTargetProject());
        pasteTestStepOperationReport.setOperationReport(this.testCaseDisplayService.findParametersData(Long.valueOf(testCaseId)));
        return pasteTestStepOperationReport;
    }

    @RequestMapping(value={"/move"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeStepsIndex(@PathVariable long testCaseId, @RequestBody MoveStepModel moveStepModel) {
        this.testCaseModificationService.changeTestStepsPosition(testCaseId, moveStepModel.newIndex.intValue(), moveStepModel.movedStepIds);
    }

    @RequestMapping(value={"/{stepIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public TestCaseParameterOperationReport deleteSteps(@PathVariable(value="stepIds") List<Long> stepIds, @PathVariable long testCaseId) {
        this.testCaseModificationService.removeListOfSteps(testCaseId, stepIds);
        return this.testCaseDisplayService.findParametersData(Long.valueOf(testCaseId));
    }

    @RequestMapping(value={"/call-test-case"}, method={RequestMethod.POST})
    @ResponseBody
    public PasteTestStepOperationReport addCallTestStep(@PathVariable(value="testCaseId") long callingTestCaseId, @RequestBody CallTestCaseModel callTestCaseModel) {
        return this.callStepManager.addCallTestSteps(callingTestCaseId, callTestCaseModel.calledTestCaseIds, callTestCaseModel.index);
    }

    @RequestMapping(value={"{stepId}/parameter-assignation-mode"}, method={RequestMethod.POST})
    @ResponseBody
    public TestCaseParameterOperationReport changeParameterAssignationMode(@PathVariable(value="testCaseId") Long testCaseId, @PathVariable(value="stepId") Long stepId, @RequestBody ParameterAssignationModel model) {
        this.callStepManager.setParameterAssignationMode(stepId.longValue(), ParameterAssignationMode.valueOf((String)model.getMode()), model.getDatasetId());
        return this.testCaseDisplayService.findParametersData(testCaseId);
    }
}

