/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.web.backend.controller.search.SearchMilestoneModificationController;

@RestController
@RequestMapping(value={"backend/search/milestones"})
public class SearchMilestoneModificationController {
    private TestCaseModificationService testCaseModificationService;
    private RequirementVersionManagerService requirementVersionManagerService;

    public SearchMilestoneModificationController(TestCaseModificationService testCaseModificationService, RequirementVersionManagerService requirementVersionManagerService) {
        this.testCaseModificationService = testCaseModificationService;
        this.requirementVersionManagerService = requirementVersionManagerService;
    }

    @RequestMapping(value={"test-case/{testCaseIds}"}, method={RequestMethod.GET})
    @ResponseBody
    public MilestoneMassEdit getMilestoneMassEditForTc(@PathVariable List<Long> testCaseIds) {
        MilestoneMassEdit data = new MilestoneMassEdit();
        data.setCheckedIds(this.testCaseModificationService.findBindedMilestonesIdForMassModif(testCaseIds));
        Collection milestones = this.testCaseModificationService.findAssociableMilestonesForMassModif(testCaseIds);
        data.setMilestoneIds((Collection)milestones.stream().map(Milestone::getId).collect(Collectors.toCollection(ArrayList::new)));
        data.setSamePerimeter(this.testCaseModificationService.haveSamePerimeter(testCaseIds));
        return data;
    }

    @RequestMapping(value={"test-case"}, method={RequestMethod.POST})
    @ResponseBody
    public void bindMilestonesToTcs(@RequestBody MilestonesPatch milestonesPatch) {
        Collection bindedBefore = this.testCaseModificationService.findBindedMilestonesIdForMassModif(milestonesPatch.getBindableObjectIds());
        bindedBefore.removeAll(milestonesPatch.getMilestoneIds());
        for (Long testCaseId : milestonesPatch.getBindableObjectIds()) {
            this.testCaseModificationService.bindMilestones(testCaseId.longValue(), (Collection)milestonesPatch.getMilestoneIds());
            this.testCaseModificationService.unbindMilestones(testCaseId.longValue(), bindedBefore);
        }
    }

    @RequestMapping(value={"requirement/{requirementVersionIds}"}, method={RequestMethod.GET})
    @ResponseBody
    public MilestoneMassEdit getMilestoneMassEditForRequirement(@PathVariable List<Long> requirementVersionIds) {
        MilestoneMassEdit data = new MilestoneMassEdit();
        data.setCheckedIds(this.requirementVersionManagerService.findBindedMilestonesIdForMassModif(requirementVersionIds));
        Collection milestones = this.requirementVersionManagerService.findAssociableMilestonesForMassModif(requirementVersionIds);
        data.setMilestoneIds((Collection)milestones.stream().map(Milestone::getId).collect(Collectors.toCollection(ArrayList::new)));
        data.setSamePerimeter(this.requirementVersionManagerService.haveSamePerimeter(requirementVersionIds));
        return data;
    }

    @RequestMapping(value={"requirement"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean bindMilestonesToReqVersions(@RequestBody MilestonesPatch milestonesPatch) {
        List reqVersionIds = milestonesPatch.getBindableObjectIds();
        List milestoneIds = milestonesPatch.getMilestoneIds();
        Collection bindedBefore = this.requirementVersionManagerService.findBindedMilestonesIdForMassModif(reqVersionIds);
        bindedBefore.removeAll(milestoneIds);
        boolean isOneVersionAlreadyBound = !milestoneIds.isEmpty() && this.requirementVersionManagerService.isOneMilestoneAlreadyBindToAnotherRequirementVersion(reqVersionIds, milestoneIds);
        for (Long reqVersionId : reqVersionIds) {
            this.requirementVersionManagerService.bindMilestones(reqVersionId.longValue(), (Collection)milestoneIds);
            this.requirementVersionManagerService.unbindMilestones(reqVersionId.longValue(), bindedBefore);
        }
        return isOneVersionAlreadyBound;
    }
}

