/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.exception.requirement.VerifiedRequirementException;
import org.squashtest.tm.service.display.requirements.RequirementDisplayService;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementVersionBundleStatsDto;
import org.squashtest.tm.service.internal.display.dto.requirement.VerifyingTestCaseDto;
import org.squashtest.tm.service.requirement.RequirementHelper;
import org.squashtest.tm.service.requirement.RequirementStatisticsService;
import org.squashtest.tm.service.testcase.VerifyingTestCaseManagerService;
import org.squashtest.tm.web.backend.controller.requirement.VerifyingTestCaseManagerController;
import org.squashtest.tm.web.backend.helper.VerifiedRequirementActionSummaryBuilder;

@Controller
@RequestMapping(value={"backend/requirement-version/{requirementVersionId}"})
public class VerifyingTestCaseManagerController {
    private VerifyingTestCaseManagerService verifyingTestCaseManager;
    private RequirementDisplayService requirementDisplayService;
    private final RequirementStatisticsService requirementStatisticsService;
    private final RequirementHelper requirementHelper;

    public VerifyingTestCaseManagerController(VerifyingTestCaseManagerService verifyingTestCaseManager, RequirementDisplayService requirementDisplayService, RequirementStatisticsService requirementStatisticsService, RequirementHelper requirementHelper) {
        this.verifyingTestCaseManager = verifyingTestCaseManager;
        this.requirementDisplayService = requirementDisplayService;
        this.requirementStatisticsService = requirementStatisticsService;
        this.requirementHelper = requirementHelper;
    }

    @ResponseBody
    @DeleteMapping(value={"/verifying-test-cases/{testCaseIds}"})
    public ChangeVerifyingTestCasesOperationReport removeVerifyingTestCaseFromRequirement(@PathVariable(value="requirementVersionId") long requirementVersionId, @PathVariable(value="testCaseIds") List<Long> testCaseIds) {
        this.verifyingTestCaseManager.removeVerifyingTestCasesFromRequirementVersion(testCaseIds, requirementVersionId);
        List verifyingTestCasesDto = this.retrieveVerifyingTestCases(Long.valueOf(requirementVersionId));
        RequirementVersionBundleStatsDto requirementStats = this.retrieveReqVersionBundleStats(requirementVersionId);
        Integer nbIssues = this.requirementDisplayService.countIssuesByRequirementVersionId(Long.valueOf(requirementVersionId));
        return new ChangeVerifyingTestCasesOperationReport(verifyingTestCasesDto, requirementStats, nbIssues);
    }

    @ResponseBody
    @PostMapping(value={"/verifying-test-cases"})
    public ChangeVerifyingTestCasesOperationReport addVerifyingTestCasesToRequirement(@RequestBody TestCaseIdsForm testCaseIdsForm, @PathVariable long requirementVersionId) {
        Map rejectionsAndIds = this.verifyingTestCaseManager.addVerifyingTestCasesToRequirementVersion(testCaseIdsForm.testCaseIds, requirementVersionId);
        Collection rejections = (Collection)rejectionsAndIds.get("REJECTION");
        Map result = this.buildSummary(rejections);
        List verifyingTestCasesDto = this.retrieveVerifyingTestCases(Long.valueOf(requirementVersionId));
        RequirementVersionBundleStatsDto requirementStats = this.retrieveReqVersionBundleStats(requirementVersionId);
        Integer nbIssues = this.requirementDisplayService.countIssuesByRequirementVersionId(Long.valueOf(requirementVersionId));
        ChangeVerifyingTestCasesOperationReport report = new ChangeVerifyingTestCasesOperationReport(verifyingTestCasesDto, requirementStats, nbIssues);
        report.setSummary(result);
        return report;
    }

    private RequirementVersionBundleStatsDto retrieveReqVersionBundleStats(long requirementVersionId) {
        return this.requirementHelper.checkIfReqIsHighLevelByReqVersionId(Long.valueOf(requirementVersionId)) ? this.requirementStatisticsService.findCoveragesStatsByHighLvlReqVersionId(Long.valueOf(requirementVersionId)) : this.requirementStatisticsService.findCoveragesStatsByRequirementVersionId(Long.valueOf(requirementVersionId));
    }

    private List<VerifyingTestCaseDto> retrieveVerifyingTestCases(Long requirementVersionId) {
        return this.requirementHelper.checkIfReqIsHighLevelByReqVersionId(requirementVersionId) ? this.requirementDisplayService.findVerifyingTestCasesByHighLvlReqVersionId(requirementVersionId) : this.requirementDisplayService.findVerifyingTestCasesByRequirementVersionId(requirementVersionId);
    }

    private Map<String, Object> buildSummary(Collection<VerifiedRequirementException> rejections) {
        return VerifiedRequirementActionSummaryBuilder.buildAddActionSummary(rejections);
    }
}

