/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.importer.testcase;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.service.importer.ImportSummary;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.web.backend.controller.importer.ImportExcelResponse;
import org.squashtest.tm.web.backend.controller.importer.testcase.TestCaseImportHelper;

@Controller
@RequestMapping(value={"backend/test-cases/importer"})
public class TestCaseImportController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseImportController.class);
    @Inject
    private TestCaseLibraryNavigationService navigationService;
    @Inject
    private TestCaseImportHelper importHelper;

    @RequestMapping(value={"/zip"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ImportSummary importZippedTestCases(@RequestParam(value="archive") MultipartFile archive, @RequestParam(value="projectId") long projectId, @RequestParam(value="zipEncoding") String zipEncoding) throws IOException {
        InputStream stream = archive.getInputStream();
        ModelAndView mav = new ModelAndView("fragment/import/import-summary");
        ImportSummary summary = this.navigationService.importZipTestCase(stream, projectId, zipEncoding);
        mav.addObject("summary", (Object)summary);
        mav.addObject("workspace", (Object)"test-case");
        return summary;
    }

    @RequestMapping(value={"/xls"}, method={RequestMethod.POST}, params={"dry-run"})
    @ResponseBody
    public ImportExcelResponse dryRunExcelWorkbook(@RequestParam(value="archive") MultipartFile uploadedFile, WebRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("dryRunExcelWorkbook");
        }
        return this.importHelper.importWorkbook("test-cases", uploadedFile, xls -> this.navigationService.simulateImportExcelTestCase(xls));
    }

    @RequestMapping(value={"/xls"}, params={"!dry-run"}, method={RequestMethod.POST})
    @ResponseBody
    public ImportExcelResponse importExcelWorkbook(@RequestParam(value="archive") MultipartFile uploadedFile) {
        return this.importHelper.importWorkbook("test-cases", uploadedFile, xls -> this.navigationService.performImportExcelTestCase(xls));
    }
}

