/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.export.grid;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.squashtest.tm.web.backend.controller.export.grid.GridExportModel;
import org.squashtest.tm.web.backend.controller.export.grid.GridExporter;

public class CsvGridExporter
extends GridExporter {
    public CsvGridExporter(GridExportModel gridExportModel) {
        super(gridExportModel);
    }

    public File export() throws IOException {
        File file = File.createTempFile("grid_export_", ".csv");
        file.deleteOnExit();
        PrintWriter writer = new PrintWriter(file);
        this.printHeaders();
        this.printRows();
        for (Row row : this.rows) {
            writer.write(String.valueOf(this.rowToString(row)) + "\n");
        }
        writer.close();
        return file;
    }

    private String rowToString(Row row) {
        StringBuilder builder = new StringBuilder();
        Iterator headerIterator = row.cellIterator();
        while (headerIterator.hasNext()) {
            Cell cell = (Cell)headerIterator.next();
            String value = this.escapeCharIfNeeded(cell.getStringCellValue());
            if (value == null) continue;
            builder.append("\"").append(value).append("\"").append(";");
        }
        return builder.toString().replaceAll(";$", "");
    }

    private String escapeCharIfNeeded(String value) {
        if (value.contains("\"")) {
            return value.replace("\"", "\"\"");
        }
        return value;
    }
}

