/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.security.authentication;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class SinglePageAppAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SinglePageAppAuthenticationFailureHandler.class);
    @Autowired
    private ObjectMapper objectMapper;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        LOGGER.debug("Authentication failure for user {}", (Throwable)exception);
        response.setStatus(200);
        response.setContentType("application/json");
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("authenticated", false);
        response.getOutputStream().print(this.objectMapper.writeValueAsString(data));
    }
}

