/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.display.campaign.AutomatedSuiteDisplayService;
import org.squashtest.tm.service.internal.display.dto.campaign.AutomatedSuiteExecutionReportDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;

@Controller
@RequestMapping(value={"backend/automated-suite/{automatedSuiteId}"})
public class AutomatedSuiteController {
    private AutomatedSuiteDisplayService automatedSuiteDisplayService;

    public AutomatedSuiteController(AutomatedSuiteDisplayService automatedSuiteDisplayService) {
        this.automatedSuiteDisplayService = automatedSuiteDisplayService;
    }

    @ResponseBody
    @PostMapping(value={"/executions"})
    public GridResponse findExecutionByAutomatedSuite(@PathVariable String automatedSuiteId, @RequestBody GridRequest request) {
        return this.automatedSuiteDisplayService.findExecutionByAutomatedSuiteID(automatedSuiteId, request);
    }

    @ResponseBody
    @GetMapping(value={"/report-urls"})
    public AutomatedSuiteExecutionReportDto findReportUrlsByAutomatedSuite(@PathVariable String automatedSuiteId) {
        return this.automatedSuiteDisplayService.findReportUrlsByAutomatedSuite(automatedSuiteId);
    }
}

