/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.api.testautomation;

import javax.inject.Inject;
import javax.validation.Valid;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.api.testautomation.execution.dto.TestExecutionStatus;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testautomation.AutomatedExecutionManagerService;

@Controller
@RequestMapping(value={"/automated-executions"})
public class AutomatedExecutionManagerController {
    @Inject
    private AutomatedExecutionManagerService automatedExecutionManager;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;

    @ResponseBody
    @RequestMapping(value={"/{id}/test-status"}, method={RequestMethod.POST})
    public void changeExecutionState(@PathVariable long id, @RequestBody @Valid TestExecutionStatus stateChange) {
        if (!this.permissionEvaluationService.hasRole("ROLE_TA_API_CLIENT")) {
            throw new AccessDeniedException("Access is denied");
        }
        this.automatedExecutionManager.changeExecutionState(id, stateChange);
    }
}

