/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import java.util.EnumSet;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.UrlBasedViewResolver;
import org.squashtest.tm.web.backend.interceptor.ActiveMilestoneInterceptor;
import org.squashtest.tm.web.backend.interceptor.LoggingInterceptor;
import org.squashtest.tm.web.backend.interceptor.SecurityExpressionResolverExposerInterceptor;
import org.squashtest.tm.web.config.AngularAppPageUrls;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    @Value(value="${squash.path.languages-path}")
    private String customI18nFilePath;
    @PersistenceUnit
    private EntityManagerFactory emf;
    @Inject
    private SecurityExpressionResolverExposerInterceptor securityExpressionResolverExposerInterceptor;
    @Inject
    private ActiveMilestoneInterceptor milestoneInterceptor;

    public void addInterceptors(InterceptorRegistry registry) {
        LoggingInterceptor loggingInterceptor = new LoggingInterceptor();
        registry.addWebRequestInterceptor((WebRequestInterceptor)loggingInterceptor);
        OpenEntityManagerInViewInterceptor osiv = new OpenEntityManagerInViewInterceptor();
        osiv.setEntityManagerFactory(this.emf);
        registry.addWebRequestInterceptor((WebRequestInterceptor)osiv);
        registry.addInterceptor((HandlerInterceptor)this.milestoneInterceptor);
        registry.addInterceptor((HandlerInterceptor)this.securityExpressionResolverExposerInterceptor).excludePathPatterns(new String[]{"/", "/login"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        EnumSet.allOf(AngularAppPageUrls.class).forEach(singlePageAppUrl -> registry.addViewController(singlePageAppUrl.urlPattern).setViewName(singlePageAppUrl.viewName));
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**/*.css", "/**/*.js", "/**/*.ts", "/**/*.json", "/**/*.jsx", "/**/*.png", "/**/*.svg", "/**/*.ttf", "/**/*.woff", "/**/*.woff2", "/**/*.zip", "/**/*.docx"}).setCachePeriod(Integer.valueOf(614880)).addResourceLocations(new String[]{"/", "classpath:/", "classpath:/META-INF/resources/", "classpath:/static/", "classpath:/public/"});
        registry.addResourceHandler(new String[]{"/**/*.html", "/**/*.docx"}).setCachePeriod(Integer.valueOf(0)).addResourceLocations(new String[]{"/", "classpath:/", "classpath:/META-INF/resources/", "classpath:/static/", "classpath:/public/"});
        registry.addResourceHandler(new String[]{"custom_translations_*.json"}).setCachePeriod(Integer.valueOf(614880)).addResourceLocations(new String[]{"file:" + this.customI18nFilePath + "/"});
    }

    @Bean
    public ViewResolver viewResolver() {
        UrlBasedViewResolver viewResolver = new UrlBasedViewResolver();
        viewResolver.setViewClass(InternalResourceView.class);
        return viewResolver;
    }
}

