/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.manager.synchronisation;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.wizard.SynchronisationPlugin;
import org.squashtest.tm.web.backend.manager.synchronisation.SynchronisationPluginManager;

@Component
public class SynchronisationPluginManagerImpl
implements SynchronisationPluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronisationPluginManagerImpl.class);
    public static final int DEFAULT_DELAY = 300;
    public static final int MIN_DELAY = 5;
    @Autowired(required=false)
    private Collection<SynchronisationPlugin> plugins = Collections.emptyList();
    @Inject
    @Named(value="squashtest.tm.service.ThreadPoolTaskScheduler")
    private TaskScheduler taskScheduler;
    @Inject
    private Environment environment;

    @PostConstruct
    public void registerSynchronisationPlugin() {
        int delay = this.getDelay();
        for (SynchronisationPlugin plugin : this.plugins) {
            LOGGER.info("Registering synchronisation plugin {} as {}", (Object)plugin, (Object)plugin.getName());
            this.taskScheduler.scheduleWithFixedDelay(plugin.performSynchronisation(), (long)delay);
        }
    }

    private int getDelay() {
        String property = this.environment.getProperty("squash.external.synchronisation.delay");
        int delay = 300;
        if (StringUtils.isNotBlank((CharSequence)property)) {
            try {
                delay = Integer.parseInt(property);
                delay = Math.max(delay, 5);
                LOGGER.info("Found the property 'squash.external.synchronisation.delay'. Delay between sync will be  : " + delay + " seconds.");
            }
            catch (NumberFormatException e) {
                LOGGER.error("Impossible to parse the property 'squash.external.synchronisation.delay' as a number. Please provide a valid synchronisation delay.");
                throw e;
            }
        }
        return delay *= 1000;
    }

    @Override
    public Collection<SynchronisationPlugin> findAll() {
        return this.plugins;
    }
}

