/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.manager.automationworkflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.automation.workflow.AutomationWorkflow;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.wizard.WorkspaceWizard;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.backend.manager.automationworkflow.AutomationWorkflowPluginManager;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Component
public class AutomationWorkflowPluginManagerImpl
implements AutomationWorkflowPluginManager {
    private static final String NONE = "NONE";
    private static final String I18N_KEY_NONE = "label.None";
    private static final String NATIVE = "NATIVE";
    private static final String I18N_KEY_NATIVE = "label.Native";
    private static final String NATIVE_SIMPLIFIED = "NATIVE_SIMPLIFIED";
    private static final String I18N_KEY_NATIVE_SIMPLIFIED = "label.NativeSimplified";
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private GenericProjectManagerService projectManager;
    @Autowired(required=false)
    Collection<AutomationWorkflow> plugins = Collections.emptyList();

    @Override
    public Map<String, String> getAutomationWorkflowsMapFilteredByIds(Collection<String> activePluginsIds, Locale locale) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put(NONE, this.i18nHelper.internationalize(I18N_KEY_NONE, locale));
        result.put(NATIVE, this.i18nHelper.internationalize(I18N_KEY_NATIVE, locale));
        result.put(NATIVE_SIMPLIFIED, this.i18nHelper.internationalize(I18N_KEY_NATIVE_SIMPLIFIED, locale));
        for (AutomationWorkflow workflow : this.plugins) {
            if (!activePluginsIds.contains(workflow.getId())) continue;
            result.put(workflow.getId(), workflow.getWorkflowName());
        }
        return result;
    }

    @Override
    public Map<String, String> getAutomationWorkflowsTypeFilteredByIds(Collection<String> activePluginsIds, Locale locale) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put(NONE, this.i18nHelper.internationalize(I18N_KEY_NONE, locale));
        result.put(NATIVE, this.i18nHelper.internationalize(I18N_KEY_NATIVE, locale));
        result.put(NATIVE_SIMPLIFIED, this.i18nHelper.internationalize(I18N_KEY_NATIVE_SIMPLIFIED, locale));
        return result;
    }

    @Override
    public Collection<String> getAutomationWorkflowsIds() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(NONE);
        result.add(NATIVE);
        result.add(NATIVE_SIMPLIFIED);
        for (AutomationWorkflow workflow : this.plugins) {
            result.add(workflow.getId());
        }
        return result;
    }

    @Override
    public Collection<AutomationWorkflowType> getAutomationWorkflowsType() {
        ArrayList<AutomationWorkflowType> result = new ArrayList<AutomationWorkflowType>();
        result.add(AutomationWorkflowType.NONE);
        result.add(AutomationWorkflowType.NATIVE);
        result.add(AutomationWorkflowType.NATIVE_SIMPLIFIED);
        if (!this.plugins.isEmpty()) {
            result.add(AutomationWorkflowType.REMOTE_WORKFLOW);
        }
        return result;
    }

    @Override
    public void enableRemoteAutomationWorkflowPlugin(String automationWorkflowtype, long projectId) {
        for (AutomationWorkflow plugin : this.plugins) {
            if (PluginType.AUTOMATION.equals((Object)plugin.getPluginType())) {
                this.projectManager.enablePluginForWorkspace(projectId, WorkspaceType.TEST_CASE_WORKSPACE, plugin.getId(), plugin.getPluginType());
                continue;
            }
            String msg = this.i18nHelper.internationalize("label.no.automation.workflow.plugin", LocaleContextHolder.getLocale());
            throw new PluginValidationException(msg);
        }
    }

    @Override
    public boolean pluginCanNotBeDisabled(WorkspaceWizard plugin, long projectId) {
        Map conf = this.projectManager.getPluginConfiguration(projectId, WorkspaceType.TEST_CASE_WORKSPACE, plugin.getId());
        return PluginType.AUTOMATION.equals((Object)plugin.getPluginType()) && this.projectManager.isProjectUsingWorkflow(projectId) && !conf.isEmpty();
    }
}

