/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.form.CheckboxInput;
import org.squashtest.tm.api.report.form.CheckboxesGroup;
import org.squashtest.tm.api.report.form.ContainerOption;
import org.squashtest.tm.api.report.form.DateInput;
import org.squashtest.tm.api.report.form.DropdownList;
import org.squashtest.tm.api.report.form.Input;
import org.squashtest.tm.api.report.form.InputsGroup;
import org.squashtest.tm.api.report.form.OptionInput;
import org.squashtest.tm.api.report.form.RadioButtonsGroup;
import org.squashtest.tm.api.report.form.TreePicker;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.campaign.CampaignModificationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.web.backend.helper.JsonHelper;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;
import org.squashtest.tm.web.backend.report.criteria.ConciseFormToCriteriaConverter;
import org.squashtest.tm.web.backend.report.criteria.MultiOptionsCriteria;
import org.squashtest.tm.web.backend.report.criteria.MultiValuesCriteria;
import org.squashtest.tm.web.backend.report.criteria.SimpleCriteria;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Component
public class ReportHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportHelper.class);
    private static final String REQUIREMENTS_IDS = "requirementsIds";
    private static final String TESTCASES_IDS = "testcasesIds";
    private static final String CAMPAIGN_IDS = "campaignIds";
    private static final String CAMPAIGN_ID = "campaignId";
    private static final String ITERATION_IDS = "iterationIds";
    private static final String ITERATION_ID = "iterationId";
    private static final String PROJECT_IDS = "projectIds";
    private static final String MILESTONES = "milestones";
    private static final String TAGS = "tags";
    private static final String OPTION = "option";
    @Inject
    private CampaignModificationService campaignModificationService;
    @Inject
    private IterationModificationService iterationModificationService;
    @Inject
    private RequirementVersionManagerService requirementVersionManagerService;
    @Inject
    private TestCaseModificationService testCaseModificationService;
    @Inject
    private GenericProjectManagerService projectManagerService;
    @Inject
    private MilestoneManagerService milestoneManagerService;
    @Inject
    private ReportsRegistry reportsRegistry;
    @Inject
    private InternationalizationHelper i18nHelper;

    public Map<String, List<String>> getAttributesFromReportDefinition(ReportDefinition def) {
        IdentifiedReportDecorator report = this.reportsRegistry.findReport(def.getPluginNamespace());
        Map<String, Object> form = null;
        try {
            form = JsonHelper.deserialize(def.getParameters());
        }
        catch (IOException e) {
            LOGGER.error("the report : " + def.getName() + " has corrupted parameters.", (Throwable)e);
        }
        Map<String, Criteria> crit = new ConciseFormToCriteriaConverter(report, Collections.singletonList(def.getProject())).convert(form);
        return this.getAttributesForReport(report, crit);
    }

    public Map<String, List<String>> getAttributesForReport(Report report, Map<String, Criteria> criteriaMap) {
        Input[] inputs;
        LinkedHashMap<String, List<String>> attributes = new LinkedHashMap<String, List<String>>();
        Input[] inputArray = inputs = report.getForm();
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            Input input = inputArray[n2];
            this.getAttributesFromInput(attributes, input, criteriaMap);
            ++n2;
        }
        return attributes;
    }

    private void getAttributesFromInput(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap) {
        switch (input.getType()) {
            case RADIO_BUTTONS_GROUP: {
                this.getAttributesFromRadioButtonsGroup(attributes, input, criteriaMap);
                break;
            }
            case CHECKBOXES_GROUP: {
                this.getAttributesFromChexBoxesGroup(attributes, input, criteriaMap);
                break;
            }
            case INPUTS_GROUP: {
                InputsGroup inputsGroup = (InputsGroup)input;
                inputsGroup.getInputs().forEach(i -> this.getAttributesFromInput(attributes, (Input)i, criteriaMap));
                break;
            }
            case CHECKBOX: {
                CheckboxInput checkboxInput = (CheckboxInput)input;
                SimpleCriteria sCrit = (SimpleCriteria)criteriaMap.get(checkboxInput.getName());
                if (!((Boolean)sCrit.getValue()).booleanValue()) break;
                this.getAttributesFromOptionInput(attributes, (OptionInput)checkboxInput, criteriaMap);
                break;
            }
            case DATE: {
                this.getAttributesFromDate(attributes, input, criteriaMap);
                break;
            }
            case DROPDOWN_LIST: {
                this.getAttributesFromDropdownList(attributes, input, criteriaMap);
                break;
            }
            case TREE_PICKER: {
                TreePicker treePicker = (TreePicker)input;
                MultiValuesCriteria mvCrit = (MultiValuesCriteria)criteriaMap.get(treePicker.getName());
                ArrayList<String> targets = new ArrayList<String>(mvCrit.getValue().values());
                this.getAttributesFromPicker(attributes, targets, mvCrit.getName());
                break;
            }
            case PROJECT_PICKER: 
            case MILESTONE_PICKER: 
            case TAG_PICKER: {
                MultiOptionsCriteria moCrit = (MultiOptionsCriteria)criteriaMap.get(input.getName());
                ArrayList<String> targets = new ArrayList<String>();
                moCrit.getSelectedOptions().forEach(o -> {
                    boolean bl = targets.add(o.toString());
                });
                this.getAttributesFromPicker(attributes, targets, moCrit.getName());
                break;
            }
        }
    }

    private void getAttributesFromRadioButtonsGroup(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap) {
        SimpleCriteria sCrit;
        RadioButtonsGroup radioButtonsGroup = (RadioButtonsGroup)input;
        SimpleCriteria finalSCrit = sCrit = (SimpleCriteria)criteriaMap.get(radioButtonsGroup.getName());
        radioButtonsGroup.getOptions().forEach(optionInput -> {
            if (optionInput.getValue().equalsIgnoreCase((String)finalSCrit.getValue())) {
                this.getAttributesFromOptionInput(attributes, (OptionInput)optionInput, criteriaMap);
            }
        });
    }

    private void getAttributesFromChexBoxesGroup(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap) {
        CheckboxesGroup checkboxesGroup = (CheckboxesGroup)input;
        MultiOptionsCriteria moCrit = (MultiOptionsCriteria)criteriaMap.get(checkboxesGroup.getName());
        checkboxesGroup.getOptions().forEach(optionInput -> moCrit.getSelectedOptions().forEach(selectedOption -> {
            if (optionInput.getValue().equalsIgnoreCase(selectedOption.toString())) {
                ArrayList<String> checkedAttributes = (ArrayList<String>)attributes.get(checkboxesGroup.getLabel());
                if (checkedAttributes == null) {
                    checkedAttributes = new ArrayList<String>();
                    attributes.put(checkboxesGroup.getLabel(), checkedAttributes);
                }
                checkedAttributes.add(optionInput.getLabel());
            }
        }));
    }

    private void getAttributesFromDropdownList(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap) {
        DropdownList dropdownList = (DropdownList)input;
        SimpleCriteria sCrit = (SimpleCriteria)criteriaMap.get(dropdownList.getName());
        dropdownList.getOptions().forEach(optionInput -> {
            if (optionInput.getValue().equalsIgnoreCase((String)sCrit.getValue())) {
                attributes.put(dropdownList.getLabel(), Arrays.asList(optionInput.getLabel()));
            }
        });
    }

    private void getAttributesFromDate(Map<String, List<String>> attributes, Input input, Map<String, Criteria> criteriaMap) {
        DateInput dateInput = (DateInput)input;
        Criteria crit = criteriaMap.get(dateInput.getName());
        Locale locale = LocaleContextHolder.getLocale();
        if (crit instanceof SimpleCriteria) {
            SimpleCriteria sCrit = (SimpleCriteria)crit;
            Date date = (Date)sCrit.getValue();
            attributes.put(dateInput.getLabel(), Arrays.asList(this.i18nHelper.localizeShortDate(date, locale)));
        } else {
            attributes.put(dateInput.getLabel(), Arrays.asList("-"));
        }
    }

    private void getAttributesFromOptionInput(Map<String, List<String>> attributes, OptionInput optionInput, Map<String, Criteria> criteriaMap) {
        ArrayList<String> options = new ArrayList<String>();
        if (optionInput instanceof ContainerOption) {
            ContainerOption containerOption = (ContainerOption)optionInput;
            this.getAttributesFromInput(attributes, containerOption.getContent(), criteriaMap);
        } else if (attributes.get(OPTION) == null) {
            attributes.put(OPTION, Arrays.asList(optionInput.getLabel()));
        } else {
            options.addAll((Collection)attributes.get(OPTION));
            options.add(optionInput.getLabel());
            attributes.put(OPTION, options);
        }
    }

    private void getAttributesFromPicker(Map<String, List<String>> attributes, List<String> targetIds, String entity) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Long> ids = new ArrayList<Long>();
        Locale locale = LocaleContextHolder.getLocale();
        String entityLabelKey = "";
        switch (entity) {
            case "campaignId": {
                entityLabelKey = "label.Campaign";
            }
            case "campaignIds": {
                targetIds.forEach(id -> {
                    boolean bl = ids.add(Long.parseLong(id));
                });
                this.handleAttributesForCampaignIds(attributes, names, ids, locale, entityLabelKey);
                break;
            }
            case "iterationId": {
                entityLabelKey = "label.iteration";
            }
            case "iterationIds": {
                targetIds.forEach(id -> {
                    boolean bl = ids.add(Long.parseLong(id));
                });
                this.handleAttributesForIterationIds(attributes, names, ids, locale, entityLabelKey);
                break;
            }
            case "requirementsIds": {
                targetIds.forEach(id -> {
                    boolean bl = ids.add(Long.parseLong(id));
                });
                List requirements = this.requirementVersionManagerService.findRequirementsAllByIds(ids);
                requirements.forEach(o -> {
                    boolean bl = names.add(o.getName());
                });
                attributes.put(this.i18nHelper.internationalize("label.requirements", locale), names);
                break;
            }
            case "testcasesIds": {
                targetIds.forEach(id -> {
                    boolean bl = ids.add(Long.parseLong(id));
                });
                List testCases = this.testCaseModificationService.findAllByIds(ids);
                testCases.forEach(o -> {
                    boolean bl = names.add(o.getName());
                });
                attributes.put(this.i18nHelper.internationalize("label.testCases", locale), names);
                break;
            }
            case "projectIds": {
                targetIds.forEach(id -> {
                    boolean bl = ids.add(Long.parseLong(id));
                });
                List genericProjects = this.projectManagerService.findAllByIds(ids);
                genericProjects.forEach(o -> {
                    boolean bl = names.add(o.getName());
                });
                attributes.put(this.i18nHelper.internationalize("label.projects", locale), names);
                break;
            }
            case "milestones": {
                targetIds.forEach(id -> {
                    boolean bl = ids.add(Long.parseLong(id));
                });
                List milestones = this.milestoneManagerService.findAllByIds(ids);
                milestones.forEach(o -> {
                    boolean bl = names.add(o.getLabel());
                });
                attributes.put(this.i18nHelper.internationalize("label.Milestone", locale), names);
                break;
            }
            case "tags": {
                targetIds.forEach(o -> {
                    boolean bl = names.add(o.toString());
                });
                attributes.put(TAGS, names);
                break;
            }
        }
    }

    private void handleAttributesForCampaignIds(Map<String, List<String>> attributes, List<String> names, List<Long> ids, Locale locale, String entityLabelKey) {
        List campaigns = this.campaignModificationService.findAllByIds(ids);
        campaigns.forEach(o -> {
            boolean bl = names.add(o.getName());
        });
        if (entityLabelKey.isEmpty()) {
            entityLabelKey = "label.campaigns";
        }
        attributes.put(this.i18nHelper.internationalize(entityLabelKey, locale), names);
    }

    private void handleAttributesForIterationIds(Map<String, List<String>> attributes, List<String> names, List<Long> ids, Locale locale, String entityLabelKey) {
        List iterations = this.iterationModificationService.findAllByIds(ids);
        iterations.forEach(o -> {
            boolean bl = names.add(o.getName());
        });
        if (entityLabelKey.isEmpty()) {
            entityLabelKey = "label.iterations";
        }
        attributes.put(this.i18nHelper.internationalize(entityLabelKey, locale), names);
    }
}

