/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.user;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsDetailedException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.domain.users.UsersGroup;
import org.squashtest.tm.exception.bugtracker.BadCredentialsException;
import org.squashtest.tm.exception.bugtracker.CannotConnectBugtrackerException;
import org.squashtest.tm.service.internal.display.dto.BugTrackerCredentialsDto;
import org.squashtest.tm.service.internal.display.dto.BugTrackerDto;
import org.squashtest.tm.service.internal.display.dto.CredentialsDto;
import org.squashtest.tm.service.internal.display.dto.ProjectPermissionDto;
import org.squashtest.tm.service.internal.display.dto.UserAccountDto;
import org.squashtest.tm.service.internal.display.dto.UsersGroupDto;
import org.squashtest.tm.service.internal.security.AuthenticationProviderContext;
import org.squashtest.tm.service.internal.servers.ManageableBasicAuthCredentials;
import org.squashtest.tm.service.internal.servers.ManageableTokenAuthCredentials;
import org.squashtest.tm.service.internal.servers.OAuth2ConsumerService;
import org.squashtest.tm.service.internal.servers.UserOAuth1aToken;
import org.squashtest.tm.service.project.ProjectsPermissionFinder;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.Oauth2Tokens;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.web.backend.controller.user.PasswordChangeForm;

@RestController
@RequestMapping(value={"backend/user-account"})
public class UserAccountController {
    private static final String SQUASH_BUGTRACKER_MODE = "squash.bug.tracker.mode";
    private final UserAccountService userAccountService;
    private final ProjectsPermissionFinder permissionFinder;
    private final PartyPreferenceService partyPreferenceService;
    private final StoredCredentialsManager credentialsManager;
    private final AuthenticationProviderContext authenticationProviderContext;
    private final OAuth2ConsumerService oAuth2ConsumerService;

    UserAccountController(UserAccountService userAccountService, ProjectsPermissionFinder permissionFinder, PartyPreferenceService partyPreferenceService, StoredCredentialsManager credentialsManager, AuthenticationProviderContext authenticationProviderContext, OAuth2ConsumerService oAuth2ConsumerService) {
        this.userAccountService = userAccountService;
        this.permissionFinder = permissionFinder;
        this.partyPreferenceService = partyPreferenceService;
        this.credentialsManager = credentialsManager;
        this.authenticationProviderContext = authenticationProviderContext;
        this.oAuth2ConsumerService = oAuth2ConsumerService;
    }

    @GetMapping
    public UserAccountDto getUserAccountDetails() {
        UserAccountDto dto = new UserAccountDto();
        User user = this.userAccountService.findCurrentUser();
        dto.setId(user.getId());
        dto.setFirstName(user.getFirstName());
        dto.setLastName(user.getLastName());
        dto.setLogin(user.getLogin());
        dto.setUserGroup(UsersGroupDto.from((UsersGroup)user.getGroup()));
        dto.setEmail(user.getEmail());
        List projectPermissions = this.permissionFinder.findProjectPermissionByUserLogin(user.getLogin()).stream().map(ProjectPermissionDto::from).collect(Collectors.toList());
        dto.setProjectPermissions(projectPermissions);
        Party party = this.userAccountService.getParty(user.getId());
        Map map = this.partyPreferenceService.findPreferences(party);
        dto.setBugTrackerMode((String)map.get(SQUASH_BUGTRACKER_MODE));
        dto.setBugTrackerCredentials(this.getBugtrackerCredentials());
        dto.setCanManageLocalPassword(this.authenticationProviderContext.isInternalProviderEnabled());
        dto.setHasLocalPassword(this.userAccountService.hasCurrentUserPasswordDefined());
        return dto;
    }

    @PostMapping(value={"{partyId}/email"})
    void changeEmail(@PathVariable Long partyId, @RequestBody UserAccountChangeRequest requestBody) {
        this.userAccountService.setCurrentUserEmail(requestBody.getEmail());
    }

    @PostMapping(value={"/password"})
    @ResponseBody
    public void changePassword(@Valid @RequestBody PasswordChangeForm form) {
        if (form.isInitializing()) {
            this.userAccountService.setCurrentUserPassword(form.getNewPassword());
        } else {
            this.userAccountService.setCurrentUserPassword(form.getOldPassword(), form.getNewPassword());
        }
    }

    @RequestMapping(value={"/bug-tracker-mode"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeUserBugtrackerMode(@RequestBody UserAccountChangeRequest requestBody) {
        this.partyPreferenceService.addOrUpdatePreferenceForCurrentUser(SQUASH_BUGTRACKER_MODE, requestBody.getBugTrackerMode());
    }

    private List<BugTrackerCredentialsDto> getBugtrackerCredentials() {
        return this.userAccountService.findAllUserBugTracker().stream().sorted(Comparator.comparing(ThirdPartyServer::getAuthenticationProtocol)).map(bt -> {
            BugTrackerCredentialsDto dto = new BugTrackerCredentialsDto();
            dto.setBugTracker(BugTrackerDto.from((BugTracker)bt));
            dto.setCredentials(CredentialsDto.from((ManageableCredentials)this.getOrCreateCredentials((BugTracker)bt)));
            return dto;
        }).collect(Collectors.toList());
    }

    private ManageableCredentials getOrCreateCredentials(BugTracker bugtracker) {
        ManageableCredentials credentials = this.credentialsManager.findCurrentUserCredentials(bugtracker.getId().longValue());
        if (credentials == null) {
            switch (bugtracker.getAuthenticationProtocol()) {
                case BASIC_AUTH: {
                    credentials = new ManageableBasicAuthCredentials("", "");
                    break;
                }
                case OAUTH_1A: {
                    credentials = new UserOAuth1aToken("", "");
                    break;
                }
                case TOKEN_AUTH: {
                    credentials = new ManageableTokenAuthCredentials("");
                    break;
                }
                case OAUTH_2: {
                    credentials = new Oauth2Tokens("", "", "", null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("AuthenticationProtocol '" + bugtracker.getAuthenticationProtocol() + "' not supported");
                }
            }
        }
        return credentials;
    }

    @PostMapping(value={"bugtracker/{bugTrackerId}/credentials"})
    @ResponseBody
    public void saveCurrentUserCredentials(@PathVariable long bugTrackerId, @RequestBody ManageableCredentials credentials) {
        try {
            this.userAccountService.testCurrentUserCredentials(bugTrackerId, credentials);
            this.userAccountService.saveCurrentUserCredentials(bugTrackerId, credentials);
        }
        catch (BugTrackerNoCredentialsDetailedException | BugTrackerNoCredentialsException e) {
            throw new BadCredentialsException((Exception)e);
        }
        catch (BugTrackerRemoteException ex) {
            throw new CannotConnectBugtrackerException((Exception)((Object)ex));
        }
    }

    @PostMapping(value={"bugtracker/{bugTrackerId}/authentication/oauth2/token"})
    @ResponseBody
    public void askOauth2Token(@PathVariable(value="bugTrackerId") long bugTrackerId, @RequestParam(value="code") String code) {
        this.oAuth2ConsumerService.getCurrentUserOauth2token(bugTrackerId, code);
    }

    @DeleteMapping(value={"bugtracker/{bugTrackerId}/credentials"})
    @ResponseBody
    public void deleteUserCredentials(@PathVariable long bugTrackerId) {
        this.userAccountService.deleteCurrentUserCredentials(bugTrackerId);
    }

    public static class UserAccountChangeRequest {
        private String email;
        private String bugTrackerMode;

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getBugTrackerMode() {
            return this.bugTrackerMode;
        }

        public void setBugTrackerMode(String bugTrackerMode) {
            this.bugTrackerMode = bugTrackerMode;
        }
    }
}

