/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.coverage;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.exception.requirement.VerifiedRequirementException;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.dto.RequirementVersionCoverageDto;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.web.backend.helper.VerifiedRequirementActionSummaryBuilder;

@Controller
public class VerifiedRequirementsController {
    private final VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    private final TestCaseDisplayService testCaseDisplayService;

    public VerifiedRequirementsController(VerifiedRequirementsManagerService verifiedRequirementsManagerService, TestCaseDisplayService testCaseDisplayService) {
        this.verifiedRequirementsManagerService = verifiedRequirementsManagerService;
        this.testCaseDisplayService = testCaseDisplayService;
    }

    @ResponseBody
    @GetMapping(value={"backend/test-cases/{testCaseId}/verified-requirements"})
    public Map<String, List<RequirementVersionCoverageDto>> getCoverages(@PathVariable long testCaseId) {
        return Collections.singletonMap("coverages", this.testCaseDisplayService.findCoverages(Long.valueOf(testCaseId)));
    }

    @ResponseBody
    @PostMapping(value={"backend/test-cases/{testCaseId}/verified-requirements"})
    public ChangeCoverageOperationReport addVerifiedRequirementsToTestCase(@RequestBody RequirementIdsForm requirementIdsForm, @PathVariable long testCaseId) {
        Collection rejections = this.verifiedRequirementsManagerService.addVerifiedRequirementsToTestCase(requirementIdsForm.requirementIds, testCaseId);
        Map<String, Object> summary = this.buildSummary(rejections);
        List coverages = this.testCaseDisplayService.findCoverages(Long.valueOf(testCaseId));
        ChangeCoverageOperationReport report = new ChangeCoverageOperationReport(coverages);
        report.setSummary(summary);
        return report;
    }

    @ResponseBody
    @PostMapping(value={"backend/test-cases/{testCaseId}/steps/{testStepId}/verified-requirements"})
    public ChangeCoverageOperationReport addVerifiedRequirementsToTestStep(@RequestBody RequirementIdsForm requirementIdsForm, @PathVariable long testCaseId, @PathVariable long testStepId) {
        Collection rejections = this.verifiedRequirementsManagerService.addVerifiedRequirementsToTestStep(requirementIdsForm.requirementIds, testStepId);
        List coverages = this.testCaseDisplayService.findCoverages(Long.valueOf(testCaseId));
        Map<String, Object> summary = this.buildSummary(rejections);
        ChangeCoverageOperationReport report = new ChangeCoverageOperationReport(coverages);
        report.setSummary(summary);
        return report;
    }

    @ResponseBody
    @PostMapping(value={"/backend/test-steps/{testStepId}/verified-requirement-versions/{requirementVersionId}"})
    public Map<String, Object> addVerifiedRequirementToTestStep(@PathVariable long requirementVersionId, @PathVariable long testStepId) {
        Collection rejections = this.verifiedRequirementsManagerService.addVerifiedRequirementVersionToTestStep(requirementVersionId, testStepId);
        return this.buildSummary(rejections);
    }

    private Map<String, Object> buildSummary(Collection<VerifiedRequirementException> rejections) {
        return VerifiedRequirementActionSummaryBuilder.buildAddActionSummary(rejections);
    }

    @ResponseBody
    @DeleteMapping(value={"backend/test-cases/{testCaseId}/verified-requirement-versions/{requirementVersionsIds}"})
    public ChangeCoverageOperationReport removeVerifiedRequirementVersionsFromTestCase(@PathVariable List<Long> requirementVersionsIds, @PathVariable long testCaseId) {
        this.verifiedRequirementsManagerService.removeVerifiedRequirementVersionsFromTestCase(requirementVersionsIds, testCaseId);
        List coverages = this.testCaseDisplayService.findCoverages(Long.valueOf(testCaseId));
        return new ChangeCoverageOperationReport(coverages);
    }

    @ResponseBody
    @DeleteMapping(value={"backend/test-cases/{testCaseId}/steps/{testStepId}/verified-requirement-versions/{requirementVersionsIds}"})
    public ChangeCoverageOperationReport removeVerifiedRequirementVersionsFromTestStep(@PathVariable List<Long> requirementVersionsIds, @PathVariable long testStepId, @PathVariable long testCaseId) {
        this.verifiedRequirementsManagerService.removeVerifiedRequirementVersionsFromTestStep(requirementVersionsIds, testStepId);
        List coverages = this.testCaseDisplayService.findCoverages(Long.valueOf(testCaseId));
        return new ChangeCoverageOperationReport(coverages);
    }

    static class ChangeCoverageOperationReport {
        private final List<RequirementVersionCoverageDto> coverages;
        private Map<String, Object> summary;

        public ChangeCoverageOperationReport(List<RequirementVersionCoverageDto> coverages) {
            this.coverages = coverages;
        }

        public List<RequirementVersionCoverageDto> getCoverages() {
            return this.coverages;
        }

        public Map<String, Object> getSummary() {
            return this.summary;
        }

        public void setSummary(Map<String, Object> summary) {
            this.summary = summary;
        }
    }

    static class RequirementIdsForm {
        private List<Long> requirementIds;

        RequirementIdsForm() {
        }

        public List<Long> getRequirementIds() {
            return this.requirementIds;
        }

        public void setRequirementIds(List<Long> requirementIds) {
            this.requirementIds = requirementIds;
        }
    }
}

