/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirements.links;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.service.display.requirements.links.RequirementsLinksDisplayService;
import org.squashtest.tm.service.internal.display.dto.RequirementsLinksTypeDto;
import org.squashtest.tm.service.requirement.RequirementVersionLinkTypeManagerService;
import org.squashtest.tm.web.backend.controller.form.model.RequirementsLinkFormModel;

@Controller
@RequestMapping(value={"/backend/requirements-links"})
public class RequirementsLinksController {
    private static final String REQUIREMENTS_LINKS_URL = "{requirementsLinksId}";
    @Inject
    RequirementsLinksDisplayService requirementsLinksDisplayService;
    @Inject
    RequirementVersionLinkTypeManagerService requirementVersionLinkTypeManagerService;

    @ResponseBody
    @PostMapping
    public RequirementLinkWrapper getAllRequirementsLinks() {
        return new RequirementLinkWrapper(this.requirementsLinksDisplayService.findAllRequirementsLinksType());
    }

    @ResponseBody
    @PostMapping(value={"/new"})
    public Map<String, Object> addRequirementsLink(@Valid @RequestBody RequirementsLinkFormModel requirementsLinkFormModel) {
        HashMap<String, Object> tempReturn = new HashMap<String, Object>();
        RequirementVersionLinkType requirementVersionLinkType = requirementsLinkFormModel.getRequirementsLink();
        this.requirementVersionLinkTypeManagerService.addLinkType(requirementVersionLinkType);
        tempReturn.put("id", requirementVersionLinkType.getId());
        return tempReturn;
    }

    @ResponseBody
    @RequestMapping(value={"{requirementsLinksId}"}, method={RequestMethod.DELETE})
    public void deleteRequirementsLink(@PathVariable(value="requirementsLinksId") List<Long> requirementsLinksId) {
        this.requirementVersionLinkTypeManagerService.deleteLinkTypes(requirementsLinksId);
    }

    static class RequirementLinkWrapper {
        List<RequirementsLinksTypeDto> requirementLinks;

        public RequirementLinkWrapper(List<RequirementsLinksTypeDto> requirementLinks) {
            this.requirementLinks = requirementLinks;
        }

        public List<RequirementsLinksTypeDto> getRequirementLinks() {
            return this.requirementLinks;
        }

        public void setRequirementLinks(List<RequirementsLinksTypeDto> requirementLinks) {
            this.requirementLinks = requirementLinks;
        }
    }
}

