/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.export;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.MessageSource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.testcase.ExportTestCaseData;
import org.squashtest.tm.domain.testcase.ExportTestStepData;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.web.backend.controller.export.ExportUtil;
import org.squashtest.tm.web.backend.report.service.JasperReportsService;

@Controller
@RequestMapping(value={"backend/test-case/export"})
public class TestCaseExportController {
    private static final String CALLS = "calls";
    private static final String JASPER_EXPORT_FILE = "WEB-INF/reports/test-case-export.jasper";
    private final MessageSource messageSource;
    private final JasperReportsService jrServices;
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;

    public TestCaseExportController(MessageSource messageSource, JasperReportsService jrServices, TestCaseLibraryNavigationService testCaseLibraryNavigationService) {
        this.messageSource = messageSource;
        this.jrServices = jrServices;
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
    }

    @RequestMapping(value={"/content/csv"}, produces={"application/octet-stream"}, method={RequestMethod.GET}, params={"filename", "libraries", "nodes", "calls", "keep-rte-format"})
    @ResponseBody
    public void exportAsCsv(Locale locale, @RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="calls") Boolean includeCalledTests, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".xls");
        List dataSource = this.testCaseLibraryNavigationService.findTestCasesToExport(libraryIds, nodeIds, includeCalledTests.booleanValue());
        if (!keepRteFormat.booleanValue()) {
            this.escapePrerequisiteAndSteps(dataSource);
        }
        this.convertHtmlSpecialCharactersToUnicode(dataSource);
        this.printExport(dataSource, filename, JASPER_EXPORT_FILE, response, locale, "csv", keepRteFormat);
    }

    @RequestMapping(value={"/content/xls"}, produces={"application/octet-stream"}, method={RequestMethod.GET}, params={"filename", "libraries", "nodes", "calls", "keep-rte-format"})
    @ResponseBody
    public FileSystemResource exportAsExcel(@RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="calls") Boolean includeCalledTests, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".xls");
        File export = this.testCaseLibraryNavigationService.exportTestCaseAsExcel(libraryIds, nodeIds, includeCalledTests.booleanValue(), keepRteFormat.booleanValue(), this.messageSource);
        return new FileSystemResource(export);
    }

    @ResponseBody
    @RequestMapping(value={"/content/keyword-scripts"}, method={RequestMethod.GET}, produces={"application/octet-stream"}, params={"filename", "libraries", "nodes"})
    public FileSystemResource exportKeywordScripts(@RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".zip");
        File file = this.testCaseLibraryNavigationService.exportKeywordTestCaseAsScriptFiles(libraryIds, nodeIds, this.messageSource);
        return new FileSystemResource(file);
    }

    @ResponseBody
    @RequestMapping(value={"/content/features"}, method={RequestMethod.GET}, produces={"application/octet-stream"}, params={"filename", "libraries", "nodes"})
    public FileSystemResource exportGherkinFeatures(@RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".zip");
        File file = this.testCaseLibraryNavigationService.exportGherkinTestCaseAsFeatureFiles(libraryIds, nodeIds, this.messageSource);
        return new FileSystemResource(file);
    }

    @RequestMapping(value={"/searchExports"}, produces={"application/octet-stream"}, method={RequestMethod.GET}, params={"filename", "nodes", "calls", "keep-rte-format"})
    @ResponseBody
    public FileSystemResource searchExportAsExcel(@RequestParam(value="filename") String filename, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="calls") Boolean includeCalledTests, @RequestParam(value="type") String type, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".xls");
        File export = this.testCaseLibraryNavigationService.searchExportTestCaseAsExcel(nodeIds, includeCalledTests.booleanValue(), keepRteFormat.booleanValue(), this.messageSource, type);
        return new FileSystemResource(export);
    }

    protected void printExport(List<ExportTestCaseData> dataSource, String filename2, String jasperExportFile, HttpServletResponse response, Locale locale, String string, Boolean keepRteFormat) {
        ExportUtil.printExport(dataSource, filename2, jasperExportFile, response, locale, string, keepRteFormat, new HashMap<String, Object>(), this.messageSource, this.jrServices);
    }

    private void escapePrerequisiteAndSteps(List<ExportTestCaseData> dataSource) {
        for (ExportTestCaseData data : dataSource) {
            String htmlPrerequisite = data.getPrerequisite();
            String prerequisite = HTMLCleanupUtils.htmlToTrimmedText((String)htmlPrerequisite);
            data.setPrerequisite(prerequisite);
            String htmlFirstAction = data.getFirstAction();
            String firstAction = HTMLCleanupUtils.htmlToTrimmedText((String)htmlFirstAction);
            data.setFirstAction(firstAction);
            String htmlFirstResult = data.getFirstExpectedResult();
            String firstResult = HTMLCleanupUtils.htmlToTrimmedText((String)htmlFirstResult);
            data.setFirstExpectedResult(firstResult);
            for (ExportTestStepData step : data.getSteps()) {
                String htmlAction = step.getAction();
                String action = HTMLCleanupUtils.htmlToTrimmedText((String)htmlAction);
                step.setAction(action);
                String htmlExpectedResult = step.getExpectedResult();
                String expectedResult = HTMLCleanupUtils.htmlToTrimmedText((String)htmlExpectedResult);
                step.setExpectedResult(expectedResult);
            }
        }
    }

    private void convertHtmlSpecialCharactersToUnicode(List<ExportTestCaseData> dataSource) {
        for (ExportTestCaseData data : dataSource) {
            data.setDescription(HtmlUtils.htmlUnescape((String)data.getDescription()));
            data.setPrerequisite(HtmlUtils.htmlUnescape((String)data.getPrerequisite()));
            data.setFirstAction(HtmlUtils.htmlUnescape((String)data.getFirstAction()));
            data.setFirstExpectedResult(HtmlUtils.htmlUnescape((String)data.getFirstExpectedResult()));
            for (ExportTestStepData step : data.getSteps()) {
                step.setAction(HtmlUtils.htmlUnescape((String)step.getAction()));
                step.setExpectedResult(HtmlUtils.htmlUnescape((String)step.getExpectedResult()));
            }
        }
    }
}

