/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import java.util.Objects;
import javax.inject.Inject;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.exception.execution.IterationTestPlanHasDeletedTestCaseException;
import org.squashtest.tm.service.campaign.TestPlanExecutionProcessingService;
import org.squashtest.tm.service.internal.display.dto.execution.TestPlanResume;
import org.squashtest.tm.web.backend.controller.execution.AbstractTestPlanExecutionRunnerController;
import org.squashtest.tm.web.backend.controller.form.model.IdList;

@RestController
@RequestMapping(value={"/backend/iteration/{iterationId}/test-plan"})
public class IterationExecutionRunnerController
extends AbstractTestPlanExecutionRunnerController<Iteration> {
    @Inject
    private TestPlanExecutionProcessingService<Iteration> iterationExecutionProcessingService;

    @RequestMapping(value={"/resume"}, method={RequestMethod.POST})
    public TestPlanResume.IterationTestPlanResume resumeIteration(@PathVariable long iterationId) {
        Execution execution = super.startResume(iterationId);
        boolean hasNextTestCase = this.hasNextTestCase(iterationId, execution);
        return new TestPlanResume.IterationTestPlanResume(Long.valueOf(iterationId), execution, hasNextTestCase);
    }

    @RequestMapping(value={"/resume-filtered-selection"}, method={RequestMethod.POST})
    public TestPlanResume resumeIterationWithFilter(@PathVariable long iterationId, @RequestBody AbstractTestPlanExecutionRunnerController.FiltersContainer filtersContainer) {
        return this.testPlanExecutionRunner.resumeWithFilteredTestPlan(iterationId, filtersContainer.getFilterValues());
    }

    @RequestMapping(value={"/relaunch"}, method={RequestMethod.POST})
    public TestPlanResume.IterationTestPlanResume relaunchIteration(@PathVariable long iterationId) {
        Execution execution = super.relaunch(iterationId);
        boolean hasNextTestCase = this.hasNextTestCase(iterationId, execution);
        return new TestPlanResume.IterationTestPlanResume(Long.valueOf(iterationId), execution, hasNextTestCase);
    }

    @RequestMapping(value={"/relaunch-filtered-selection"}, method={RequestMethod.POST})
    public TestPlanResume relaunchIterationWithFilter(@PathVariable long iterationId, @RequestBody AbstractTestPlanExecutionRunnerController.FiltersContainer filtersContainer) {
        return this.testPlanExecutionRunner.relaunchFilteredTestPlan(iterationId, filtersContainer.getFilterValues());
    }

    @Override
    ActionException getTestPlanHasDeletedTestCaseException() {
        return new IterationTestPlanHasDeletedTestCaseException();
    }

    @RequestMapping(value={"/{testPlanItemId}/next-execution"})
    public TestPlanResume.IterationTestPlanResume moveToNextTestCase(@PathVariable(value="testPlanItemId") long testPlanItemId, @PathVariable(value="iterationId") long iterationId) {
        Execution execution = this.testPlanExecutionRunner.startResumeNextExecution(iterationId, testPlanItemId);
        boolean hasNextTestCase = this.hasNextTestCase(iterationId, execution);
        return new TestPlanResume.IterationTestPlanResume(Long.valueOf(iterationId), execution, hasNextTestCase);
    }

    @RequestMapping(value={"/{testPlanItemId}/next-execution-filtered-selection"})
    public TestPlanResume moveToNextTestCaseOfFilteredTestPlan(@PathVariable(value="testPlanItemId") long testPlanItemId, @PathVariable(value="iterationId") long iterationId, @RequestBody IdList partialTestPlan) {
        return this.testPlanExecutionRunner.resumeNextExecutionOfFilteredTestPlan(iterationId, testPlanItemId, partialTestPlan.getIds());
    }

    private boolean hasNextTestCase(long iterationId, Execution execution) {
        boolean hasNextTestCase = false;
        if (Objects.nonNull(execution)) {
            hasNextTestCase = this.iterationExecutionProcessingService.hasMoreExecutableItems(iterationId, execution.getTestPlan().getId().longValue());
        }
        return hasNextTestCase;
    }

    @Override
    boolean hasDeletedTestCaseInTestPlan(long iterationId) {
        return ((Iteration)this.entityFinder.findById(iterationId)).getTestPlans().stream().anyMatch(c -> c.getReferencedTestCase() == null);
    }
}

