/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.campaign.CreatedTestPlanItems;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.campaign.TestSuiteTestPlanManagerService;
import org.squashtest.tm.service.display.campaign.TestSuiteDisplayService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.TestSuiteKnownIssueFinder;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.web.backend.controller.campaign.IterationTestPlanManagerController;
import org.squashtest.tm.web.backend.controller.campaign.TestCaseIdForm;

@RestController
@RequestMapping(value={"backend/test-suite"})
public class TestSuiteTestPlanManagerController {
    private final TestSuiteTestPlanManagerService testSuiteTestPlanManagerService;
    private final IterationTestPlanManagerService iterationTestPlanManagerService;
    private final TestSuiteDisplayService testSuiteDisplayService;
    private final TestSuiteKnownIssueFinder testSuiteKnownIssueFinder;

    public TestSuiteTestPlanManagerController(TestSuiteTestPlanManagerService testSuiteTestPlanManagerService, IterationTestPlanManagerService iterationTestPlanManagerService, TestSuiteDisplayService testSuiteDisplayService, TestSuiteKnownIssueFinder testSuiteKnownIssueFinder) {
        this.testSuiteTestPlanManagerService = testSuiteTestPlanManagerService;
        this.iterationTestPlanManagerService = iterationTestPlanManagerService;
        this.testSuiteDisplayService = testSuiteDisplayService;
        this.testSuiteKnownIssueFinder = testSuiteKnownIssueFinder;
    }

    @RequestMapping(value={"{testSuiteId}/test-plan"}, method={RequestMethod.POST})
    public GridResponse findIterationTestPlan(@PathVariable Long testSuiteId, @RequestBody GridRequest gridRequest) {
        return this.testSuiteDisplayService.findTestPlan(testSuiteId, gridRequest);
    }

    @ResponseBody
    @RequestMapping(value={"/{testSuiteId}/test-plan-items"}, method={RequestMethod.POST})
    public CreatedTestPlanItems addTestCasesToTestSuite(@RequestBody TestCaseIdForm testCaseIdForm, @PathVariable long testSuiteId) {
        return this.testSuiteTestPlanManagerService.addTestCasesToIterationAndTestSuite(testCaseIdForm.getTestCaseIds(), testSuiteId);
    }

    @ResponseBody
    @RequestMapping(value={"/{testSuiteId}/test-plan-items/detach/{testPlanItemsIds}"}, method={RequestMethod.DELETE})
    public DeletedTestPlanItemReport detachTestCaseFromTestSuite(@PathVariable Long testSuiteId, @PathVariable List<Long> testPlanItemsIds) {
        this.testSuiteTestPlanManagerService.detachTestPlanFromTestSuite(testPlanItemsIds, testSuiteId.longValue());
        DeletedTestPlanItemReport report = new DeletedTestPlanItemReport();
        report.setNbIssues(this.testSuiteKnownIssueFinder.countKnownIssues(testSuiteId));
        return report;
    }

    @ResponseBody
    @RequestMapping(value={"/{testSuiteId}/test-plan-items/remove/{testPlanItemsIds}"}, method={RequestMethod.DELETE})
    public DeletedTestPlanItemReport removeTestCaseFromTestSuiteAndIteration(@PathVariable Long testSuiteId, @PathVariable List<Long> testPlanItemsIds) {
        this.testSuiteTestPlanManagerService.detachTestPlanFromTestSuiteAndRemoveFromIteration(testPlanItemsIds, testSuiteId.longValue());
        DeletedTestPlanItemReport report = new DeletedTestPlanItemReport();
        report.setNbIssues(this.testSuiteKnownIssueFinder.countKnownIssues(testSuiteId));
        return report;
    }

    @ResponseBody
    @RequestMapping(value={"{testSuiteId}/test-plan/execution/{executionIds}"}, method={RequestMethod.DELETE})
    public DeletedExecutionFromTestPlanItemReport removeExecutionsFromTestPlanItem(@PathVariable(value="executionIds") List<Long> executionIds, @PathVariable long testSuiteId) {
        Long iterationId = this.testSuiteDisplayService.findIterationIdByTestsuiteId(Long.valueOf(testSuiteId));
        this.iterationTestPlanManagerService.removeExecutionsFromTestPlanItem(executionIds, iterationId);
        DeletedExecutionFromTestPlanItemReport report = new DeletedExecutionFromTestPlanItemReport();
        report.setNbIssues(this.testSuiteKnownIssueFinder.countKnownIssues(Long.valueOf(testSuiteId)));
        return report;
    }

    @ResponseBody
    @RequestMapping(value={"/test-plan/{itemIds}/mass-update"})
    public void massUpdate(@PathVariable(value="itemIds") List<Long> itemIds, @RequestBody IterationTestPlanManagerController.ItpiMassEditPatch patch) {
        if (patch.getExecutionStatus() != null) {
            this.iterationTestPlanManagerService.forceExecutionStatus(itemIds, patch.getExecutionStatus());
        }
        if (patch.isChangeAssignee()) {
            if (patch.getAssignee() == null) {
                this.iterationTestPlanManagerService.removeTestPlanItemsAssignments(itemIds);
            } else {
                this.iterationTestPlanManagerService.assignUserToTestPlanItems(itemIds, patch.getAssignee().longValue());
            }
        }
    }

    @ResponseBody
    @RequestMapping(value={"/{testSuiteId}/test-plan/{itemIds}/position/{newIndex}"}, method={RequestMethod.POST})
    public void moveTestPlanItems(@PathVariable long testSuiteId, @PathVariable List<Long> itemIds, @PathVariable int newIndex) {
        this.testSuiteTestPlanManagerService.changeTestPlanPosition(testSuiteId, newIndex, itemIds);
    }

    static class DeletedExecutionFromTestPlanItemReport {
        private long nbIssues;

        DeletedExecutionFromTestPlanItemReport() {
        }

        public long getNbIssues() {
            return this.nbIssues;
        }

        public void setNbIssues(long nbIssues) {
            this.nbIssues = nbIssues;
        }
    }

    static class DeletedTestPlanItemReport {
        private long nbIssues;

        DeletedTestPlanItemReport() {
        }

        public long getNbIssues() {
            return this.nbIssues;
        }

        public void setNbIssues(long nbIssues) {
            this.nbIssues = nbIssues;
        }
    }
}

