/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.security.authentication.customauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.web.security.authentication.customauth.InvalidCustomAuthTokenException;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomAuthTokenGenerator<T> {
    private static final String JWT_HEADER = "{\"alg\":\"HS256\",\"typ\":\"JWT\"}";
    private final ObjectMapper objectMapper;
    private final String secret;

    public CustomAuthTokenGenerator(@NotBlank String secret) {
        if (StringUtils.isEmpty((CharSequence)secret)) {
            throw new IllegalArgumentException("Crypto secret must be configured.");
        }
        this.secret = secret;
        this.objectMapper = new ObjectMapper();
    }

    public String generateToken(T payload) throws IOException {
        String jsonPayload = this.objectMapper.writeValueAsString(payload);
        String signature = CustomAuthTokenGenerator.hmacSha256((String)(String.valueOf(CustomAuthTokenGenerator.encBase64((String)"{\"alg\":\"HS256\",\"typ\":\"JWT\"}")) + "." + CustomAuthTokenGenerator.encBase64((String)jsonPayload)), (String)this.secret);
        return String.valueOf(CustomAuthTokenGenerator.encBase64((String)"{\"alg\":\"HS256\",\"typ\":\"JWT\"}")) + "." + CustomAuthTokenGenerator.encBase64((String)jsonPayload) + "." + signature;
    }

    public boolean isValidToken(String token) {
        String[] parts = token.split("\\.");
        String header = CustomAuthTokenGenerator.decBase64((String)parts[0]);
        this.checkHeader(header);
        this.checkSignature(parts[0], parts[1], parts[2]);
        return true;
    }

    private void checkHeader(String header) {
        if (!"{\"alg\":\"HS256\",\"typ\":\"JWT\"}".equals(header)) {
            throw new InvalidCustomAuthTokenException("Invalid header.");
        }
    }

    private void checkSignature(String header, String payload, String signature) {
        String headerAndPayloadHashed = CustomAuthTokenGenerator.hmacSha256((String)(String.valueOf(header) + "." + payload), (String)this.secret);
        if (headerAndPayloadHashed == null || !headerAndPayloadHashed.equals(signature)) {
            throw new InvalidCustomAuthTokenException("Invalid signature.");
        }
    }

    private static String hmacSha256(String data, String secret) {
        try {
            byte[] hash = secret.getBytes(StandardCharsets.UTF_8);
            Mac sha256Hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(hash, "HmacSHA256");
            sha256Hmac.init(secretKey);
            byte[] signedBytes = sha256Hmac.doFinal(data.getBytes(StandardCharsets.UTF_8));
            return CustomAuthTokenGenerator.encBase64((byte[])signedBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new InvalidCustomAuthTokenException("Error while encoding data.", (Throwable)ex);
        }
    }

    private static String encBase64(String input) {
        return CustomAuthTokenGenerator.encBase64((byte[])input.getBytes());
    }

    private static String decBase64(String input) {
        return CustomAuthTokenGenerator.decBase64((byte[])input.getBytes());
    }

    private static String encBase64(byte[] bytes) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    private static String decBase64(byte[] bytes) {
        return new String(Base64.getUrlDecoder().decode(bytes));
    }
}

