/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.user.UserAdministrationService;
import org.squashtest.tm.web.backend.controller.RootController;

@Component
@Configuration
public class SquashAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private RequestCache requestCache = new HttpSessionRequestCache();
    @Inject
    private UserAdministrationService userAdministrationService;

    public SquashAuthenticationSuccessHandler() {
        this.setUseReferer(true);
        this.setAlwaysUseDefaultTargetUrl(false);
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        String targetUrl;
        HttpSession session = request.getSession();
        UserDetails authUser = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        session.setAttribute("username", (Object)authUser.getUsername());
        response.setStatus(200);
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        String string = targetUrl = savedRequest != null ? savedRequest.getRedirectUrl() : RootController.getDefaultAuthenticatedRedirectUrlForUserAuthority();
        if (!this.userAdministrationService.findPostLoginInformation().isEmpty()) {
            this.getRedirectStrategy().sendRedirect(request, response, String.format("/information?%s=%s", "redirect-after-auth", targetUrl));
        } else {
            this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
        }
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }
}

