/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.report.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import org.springframework.stereotype.Service;
import org.squashtest.tm.web.backend.report.service.AlreadyMappedException;
import org.squashtest.tm.web.backend.report.service.UnsupportedFormatException;

@Service(value="squashtest.tm.service.JasperReportsService")
public class JasperReportsService {
    private final Map<String, Class<? extends JRExporter>> exporterMaps = new HashMap();

    public JasperReportsService() {
        this.registerFormat("csv", JRCsvExporter.class);
        this.registerFormat("xls", JRXlsExporter.class);
    }

    public Set<String> getSupportedformats() {
        return this.exporterMaps.keySet();
    }

    public boolean isSupported(String format) {
        return this.exporterMaps.keySet().contains(format);
    }

    private void registerFormat(String format, Class<? extends JRExporter> jrExporterClass) {
        if (this.isSupported(format)) {
            Class clazz = (Class)this.exporterMaps.get(format);
            throw new AlreadyMappedException("the format " + format + " is already mapped to " + clazz.getName());
        }
        this.exporterMaps.put(format, jrExporterClass);
    }

    private JRExporter getExporter(String format) {
        Class exporterClass = (Class)this.exporterMaps.get(format);
        if (exporterClass == null) {
            throw new UnsupportedFormatException("no exporter defined for " + format);
        }
        try {
            return (JRExporter)exporterClass.newInstance();
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getReportAsStream(InputStream jasperStream, String format, Collection<?> dataSource, Map reportParameter, Map<JRExporterParameter, Object> exportParameter) {
        try {
            JRExporter exporter = this.getExporter(format);
            JRBeanCollectionDataSource jasperDataSource = new JRBeanCollectionDataSource(dataSource);
            JasperPrint jPrint = JasperFillManager.fillReport((InputStream)jasperStream, (Map)reportParameter, (JRDataSource)jasperDataSource);
            File reportFile = File.createTempFile("export", format);
            reportFile.deleteOnExit();
            FileOutputStream reportOut = new FileOutputStream(reportFile);
            exportParameter.put(JRExporterParameter.OUTPUT_STREAM, reportOut);
            exportParameter.put(JRExporterParameter.JASPER_PRINT, jPrint);
            exporter.setParameters(exportParameter);
            exporter.exportReport();
            return new FileInputStream(reportFile);
        }
        catch (IOException | JRException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

