/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.web.backend.exceptionresolver.DeprecatedFieldValidationErrorModel;

@Component
public class HandlerBugTrackerRemoteExceptionResolver
extends AbstractHandlerExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex)) {
            response.setStatus(412);
            BugTrackerRemoteException remoteException = (BugTrackerRemoteException)ex;
            List errors = this.buildFieldValidationErrors(remoteException);
            return new ModelAndView((View)new MappingJackson2JsonView(), "fieldValidationErrors", (Object)errors);
        }
        return null;
    }

    private List<DeprecatedFieldValidationErrorModel> buildFieldValidationErrors(BugTrackerRemoteException remoteException) {
        ArrayList<DeprecatedFieldValidationErrorModel> ves = new ArrayList<DeprecatedFieldValidationErrorModel>();
        ves.add(new DeprecatedFieldValidationErrorModel("", "bugtracker", remoteException.getMessage()));
        return ves;
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ex instanceof BugTrackerRemoteException;
    }
}

