/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.tf;

import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.internal.dto.executioncomparator.TestExecutionInfo;
import org.squashtest.tm.service.testautomation.AutomatedSuiteManagerService;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteCreationSpecification;
import org.squashtest.tm.service.testautomation.model.AutomatedSuitePreview;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteWithSquashAutomAutomatedITPIs;
import org.squashtest.tm.web.backend.controller.tf.AutomatedExecutionViewUtils;

@Controller
@RequestMapping(value={"backend/automated-suites"})
public class AutomatedSuiteManagementController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedSuiteManagementController.class);
    @Inject
    private AutomatedSuiteManagerService automatedSuiteService;

    @PostMapping(value={"/preview"})
    @ResponseBody
    public AutomatedSuitePreview generateSuitePreview(@RequestBody AutomatedSuiteCreationSpecification specification) {
        return this.automatedSuiteService.preview(specification);
    }

    @ResponseBody
    @PostMapping(value={"/preview/test-list"}, params={"auto-project-id"})
    public List<String> findTestListPreview(@RequestBody AutomatedSuiteCreationSpecification specification, @RequestParam(value="auto-project-id") Long automatedProjectId) {
        return this.automatedSuiteService.findTestListPreview(specification, automatedProjectId.longValue());
    }

    @ResponseBody
    @PostMapping(value={"/create-and-execute"})
    public AutomatedExecutionViewUtils.AutomatedSuiteOverview createAndExecute(@RequestBody AutomatedSuiteCreationSpecification specification) {
        AutomatedSuiteWithSquashAutomAutomatedITPIs suite = this.automatedSuiteService.createAndExecute(specification);
        Date startDate = new Date();
        LOGGER.debug("START CREATING AUTOMATED SUITE OVERVIEW " + startDate);
        AutomatedExecutionViewUtils.AutomatedSuiteOverview automatedSuiteOverview = AutomatedExecutionViewUtils.buildExecInfo((AutomatedSuiteWithSquashAutomAutomatedITPIs)suite);
        Date endDate = new Date();
        LOGGER.debug("END CREATING AUTOMATED SUITE OVERVIEW " + endDate);
        if (suite.getErrorMessage() != null) {
            automatedSuiteOverview.setErrorMessage(suite.getErrorMessage());
        } else if (suite.getWorkflowsUUIDs() != null && !suite.getWorkflowsUUIDs().isEmpty()) {
            automatedSuiteOverview.setWorkflowsUUIDs(suite.getWorkflowsUUIDs());
        }
        return automatedSuiteOverview;
    }

    @ResponseBody
    @GetMapping(value={"/{suiteId}/executions"})
    public AutomatedExecutionViewUtils.AutomatedSuiteOverview updateExecutionInfo(@PathVariable String suiteId) {
        AutomatedSuite suite = this.automatedSuiteService.findById(suiteId);
        return AutomatedExecutionViewUtils.buildExecInfo((AutomatedSuite)suite);
    }

    @ResponseBody
    @PostMapping(value={"/compare-executions"})
    public List<TestExecutionInfo> compareExecutions(@RequestBody List<String> suiteIds) {
        return this.automatedSuiteService.compareExecutionsBySuites(suiteIds);
    }
}

