/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.system;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.api.report.DocxTemplaterReport;
import org.squashtest.tm.api.wizard.SynchronisationPlugin;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.service.actionword.ActionWordLibraryNodeService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.display.dto.RemoteSynchronisationDto;
import org.squashtest.tm.service.internal.display.dto.ReportTemplateModel;
import org.squashtest.tm.service.internal.display.dto.SynchronisationPluginViewDto;
import org.squashtest.tm.service.internal.display.dto.SystemViewDto;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.system.SystemAdministrationService;
import org.squashtest.tm.service.user.UserManagerService;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;

@RestController
@RequestMapping(value={"/backend/system-view"})
public class SystemViewController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemViewController.class);
    private final SystemAdministrationService systemAdministrationService;
    private final FeatureManager featureManager;
    private final UserManagerService userManagerService;
    private final ActionWordLibraryNodeService actionWordLibraryNodeService;
    private final Environment environment;
    private final ReportsRegistry reportsRegistry;
    private final PermissionEvaluationService permissionEvaluationService;
    @Value(value="${logging.dir}")
    private String loggingPath;
    @Value(value="${info.app.version}")
    private String appVersion;
    @Value(value="${squashtm.stack.trace.control.panel.visible:false}")
    private Boolean stackTracePanelIsVisible;
    @Autowired(required=false)
    private Collection<SynchronisationPlugin> synchronisationPlugins = Collections.emptyList();

    SystemViewController(SystemAdministrationService administrationService, FeatureManager featureManager, UserManagerService userManagerService, Environment environment, ActionWordLibraryNodeService actionWordLibraryNodeService, ReportsRegistry reportsRegistry, PermissionEvaluationService permissionEvaluationService) {
        this.systemAdministrationService = administrationService;
        this.featureManager = featureManager;
        this.userManagerService = userManagerService;
        this.environment = environment;
        this.actionWordLibraryNodeService = actionWordLibraryNodeService;
        this.reportsRegistry = reportsRegistry;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @GetMapping
    public SystemViewDto getSystemView() {
        SystemViewDto dto = new SystemViewDto();
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            dto.setStatistics(this.systemAdministrationService.findAdministrationStatistics());
            dto.setAppVersion(this.appVersion);
            dto.setPlugins(this.systemAdministrationService.findAllPluginsAtStart());
            dto.setWhiteList(this.systemAdministrationService.findWhiteList());
            dto.setUploadSizeLimit(this.systemAdministrationService.findUploadSizeLimit());
            dto.setImportSizeLimit(this.systemAdministrationService.findImportSizeLimit());
            dto.setCallbackUrl(this.systemAdministrationService.findCallbackUrl());
            dto.setStackTracePanelIsVisible(this.stackTracePanelIsVisible.booleanValue());
            dto.setStackTraceFeatureIsEnabled(this.featureManager.isEnabled(FeatureManager.Feature.STACK_TRACE));
            dto.setAutoconnectOnConnection(this.featureManager.isEnabled(FeatureManager.Feature.AUTOCONNECT_ON_CONNECTION));
            dto.setCaseInsensitiveLogin(this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN));
            dto.setDuplicateLogins(this.userManagerService.findAllDuplicateLogins());
            dto.setCaseInsensitiveActions(this.featureManager.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS));
            dto.setDuplicateActions(this.actionWordLibraryNodeService.findAllCaseInsensitiveDuplicateActions());
            dto.setWelcomeMessage(this.systemAdministrationService.findWelcomeMessage());
            dto.setLoginMessage(this.systemAdministrationService.findLoginMessage());
            dto.setLogFiles(this.getAllLogFileNames());
            dto.setLicenseInfo(this.systemAdministrationService.getBasicLicenseInfo());
            dto.setReportTemplateModels(this.getTemplateModels());
        }
        this.appendSyncPluginsInfo(dto);
        return dto;
    }

    private void appendSyncPluginsInfo(SystemViewDto systemViewDto) {
        ArrayList syncPluginDtos = new ArrayList();
        this.synchronisationPlugins.forEach(syncPlugin -> {
            SynchronisationPluginViewDto syncPluginDto = new SynchronisationPluginViewDto();
            syncPluginDto.setId(syncPlugin.getId());
            syncPluginDto.setName(syncPlugin.getName());
            syncPluginDto.setRemoteSynchronisations(this.findRemoteSynchronisationsForPlugin(syncPlugin.getId()));
            syncPluginDto.setHasSupervisionScreen(syncPlugin.hasSupervisionScreen());
            syncPluginDto.setSupervisionScreenData(syncPlugin.getSupervisionScreenData());
            syncPluginDtos.add(syncPluginDto);
        });
        systemViewDto.setSynchronisationPlugins(syncPluginDtos);
    }

    @GetMapping(value={"/current-active-users-count"})
    @ResponseBody
    public Map<String, Integer> getCurrentActiveUsersCount() {
        HashMap<String, Integer> responseBody = new HashMap<String, Integer>();
        int currentActiveUsersCount = this.userManagerService.countAllActiveUsersAssignedToAtLeastOneProject();
        responseBody.put("currentActiveUsersCount", currentActiveUsersCount);
        return responseBody;
    }

    private List<String> getAllLogFileNames() {
        if (Arrays.asList(this.environment.getActiveProfiles()).contains("dev")) {
            return new ArrayList<String>();
        }
        return this.findAllLogFiles().stream().map(File::getName).collect(Collectors.toList());
    }

    private List<File> findAllLogFiles() {
        File logsFolder = new File(this.loggingPath);
        if (!logsFolder.exists() || !logsFolder.isDirectory()) {
            LOGGER.warn("Logs path '{}' is not a readable folder. There will be no log files", (Object)logsFolder.getAbsolutePath());
            return new ArrayList<File>();
        }
        LOGGER.info("Enumerating log files in folder '{}'", (Object)logsFolder.getAbsolutePath());
        File[] logFiles = logsFolder.listFiles((dir, name) -> name.startsWith("squash-tm.log."));
        if (logFiles != null) {
            return Arrays.stream(logFiles).collect(Collectors.toList());
        }
        return new ArrayList<File>();
    }

    private List<ReportTemplateModel> getTemplateModels() {
        ArrayList<ReportTemplateModel> reportTemplateModels = new ArrayList<ReportTemplateModel>();
        this.reportsRegistry.getSortedReports().stream().filter(IdentifiedReportDecorator::isDocxTemplate).forEach(reportDecorator -> {
            DocxTemplaterReport docxTemplaterReport = (DocxTemplaterReport)reportDecorator.getReport();
            List models = this.findTemplateModelsFromFolderPath(reportDecorator.getNamespace(), docxTemplaterReport.getCustomTemplateFolderPath());
            reportTemplateModels.addAll(models);
        });
        return reportTemplateModels;
    }

    private List<ReportTemplateModel> findTemplateModelsFromFolderPath(String namespace, @NotNull String folderPath) {
        File[] customTemplates = new File(folderPath).listFiles();
        if (customTemplates != null) {
            return Stream.of(customTemplates).filter(customTemplate -> !customTemplate.isDirectory()).map(File::getName).filter(customTemplateName -> "docx".equals(FilenameUtils.getExtension((String)customTemplateName))).map(fileName -> new ReportTemplateModel(namespace, fileName)).collect(Collectors.toList());
        }
        return new ArrayList<ReportTemplateModel>();
    }

    private List<RemoteSynchronisationDto> findRemoteSynchronisationsForPlugin(String pluginId) {
        List synchronisations = this.systemAdministrationService.findRemoteSynchronisationForPlugin(pluginId);
        return synchronisations.stream().map(arg_0 -> this.transformRemoteSynchronisationInDto(arg_0)).collect(Collectors.toList());
    }

    private RemoteSynchronisationDto transformRemoteSynchronisationInDto(RemoteSynchronisation remoteSync) {
        return new RemoteSynchronisationDto(remoteSync);
    }
}

