/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.scm.server;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.core.scm.api.exception.ScmException;
import org.squashtest.tm.exception.scmserver.ScmPluginException;
import org.squashtest.tm.service.display.scm.server.ScmServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.ScmRepositoryDto;
import org.squashtest.tm.service.scmserver.ScmRepositoryManagerService;
import org.squashtest.tm.web.backend.controller.form.model.ScmRepositoryFormModel;
import org.squashtest.tm.web.backend.controller.scm.server.ScmRepositoryManagementController;

@Controller
@RequestMapping(value={"/backend/scm-repositories"})
public class ScmRepositoryManagementController {
    ScmRepositoryManagerService scmRepositoryManager;
    ScmServerDisplayService scmServerDisplayService;

    @Inject
    ScmRepositoryManagementController(ScmRepositoryManagerService scmRepositoryManager, ScmServerDisplayService scmServerDisplayService) {
        this.scmRepositoryManager = scmRepositoryManager;
        this.scmServerDisplayService = scmServerDisplayService;
    }

    @RequestMapping(value={"/{scmServerId}/new"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, List<ScmRepositoryDto>> createNewScmRepository(@PathVariable long scmServerId, @RequestBody ScmRepositoryFormModel scmRepositoryFormModel) throws IOException {
        try {
            this.scmRepositoryManager.createNewScmRepository(scmServerId, scmRepositoryFormModel.getScmRepository(), scmRepositoryFormModel.getCloneRepository());
        }
        catch (ScmException ex) {
            throw new ScmPluginException(ex.getField(), (Exception)((Object)ex));
        }
        List repositories = this.scmServerDisplayService.getScmServerView(scmServerId).getRepositories();
        return Collections.singletonMap("repositories", repositories);
    }

    @RequestMapping(value={"/{scmServerId}/{scmRepositoryId}/branch"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, List<ScmRepositoryDto>> updateBranch(@PathVariable long scmServerId, @PathVariable long scmRepositoryId, @RequestBody ScmRepositoryPatch patch) throws IOException {
        try {
            this.scmRepositoryManager.updateBranch(scmRepositoryId, patch.getBranch());
        }
        catch (ScmException ex) {
            throw new ScmPluginException(ex.getField(), (Exception)((Object)ex));
        }
        List repositories = this.scmServerDisplayService.getScmServerView(scmServerId).getRepositories();
        return Collections.singletonMap("repositories", repositories);
    }

    @RequestMapping(value={"/{scmRepositoriesIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteScmRepositories(@PathVariable List<Long> scmRepositoriesIds) {
        this.scmRepositoryManager.deleteScmRepositories(scmRepositoriesIds);
    }

    @RequestMapping(value={"check-bound-to-project/{scmRepositoryIds}"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isOneRepositoryBoundToProject(@PathVariable Collection<Long> scmRepositoryIds) {
        return this.scmRepositoryManager.isOneRepositoryBoundToProjectOrTestCase(scmRepositoryIds);
    }
}

